var base_url = $('base').attr('data-base');
var collect_vat = $('base[data-collect-vat]').attr('data-collect-vat');
var currency = $('base[data-currency]').attr('data-currency');
var role = $('base[data-role]').attr('data-role');
$(document).ready(function(){
	$('#search_running_orders').on('keyup',function(){
		var string = $(this).val();
		$('#order_details_holder .single_order').each(function(i, obj) {
			var order_number = $(this).find('.running_order_order_number').html();
			var table_name = $(this).find('.running_order_table_name').html();
			var waiter_name = $(this).find('.running_order_waiter_name').html();
			var customer_name = $(this).find('.running_order_customer_name').html();
			if(order_number.includes(string) || table_name.includes(string) || waiter_name.includes(string) || customer_name.includes(string)){
				$(this).css('display','block');
			}else{
				$(this).css('display','none');
			}
		});
		$('#stop_refresh_for_search').html('no');
	});
	$('#kitchen_waiter_bar_button').on('click',function(){
		$('#kitchen_bar_waiter_panel_button_modal').fadeIn('500');
	});
	$('#submit_table_modal').on('click',function(){
		$('#show_tables_modal2').fadeOut('500');
	});
	$('.bottom_add').on('click',function(){
		var table_id = $(this).attr('id').substr(38);
		var order_number = $('#single_table_order_details_bottom_order_'+table_id).val();
		order_number = (order_number=="")?"New":order_number;
		var person = $('#single_table_order_details_bottom_person_'+table_id).val();
		var available_sit = $('#sit_available_number_'+table_id).html();
		if(parseInt(person)>parseInt(available_sit)){
			swal({
				title: 'Alert',
				text: 'Exceeding available sit!!',
                confirmButtonColor: '#b6d6f6' 
			});
			return false;
		}
		if(parseInt(person)<=0){
			swal({
				title: 'Alert',
				text: 'Seat number must be greater than zero!!!',
                confirmButtonColor: '#b6d6f6' 
			});
			return false;
		}
		var table_book_row = '';
		table_book_row += '<div class="single_row fix new_book_to_table" id="new_order_table_'+table_id+'">';
            table_book_row += '<div class="floatleft fix column first_column">'+order_number+'</div>';
            table_book_row += '<div class="floatleft fix column second_column">-</div>';
            table_book_row += '<div class="floatleft fix column third_column">'+person+'</div>';
            table_book_row += '<div class="floatleft fix column forth_column"><i class="fas fa-trash-alt remove_new_order_row_icon" id="single_row_table_delete_'+table_id+'"></i></div>';
        table_book_row += '</div>';
        $('#single_table_order_details_top_'+table_id).append($(table_book_row));
        $('#single_table_order_details_bottom_'+table_id).hide();
        // $('#single_table_order_details_top_'+table_id).remove();
	});

	$(document).on('click','.remove_table_order',function(){
		var orders_table_id = $(this).attr('id').substr(19);
		var r = confirm("Are you sure to cancel this booking?");
		if (r ==false) {

			return false;
		}
		$(this).parent().parent().remove();
		$.ajax({
			url:base_url+"Sale/remove_a_table_booking_ajax",
			method:"POST",
			data:{
				orders_table_id : orders_table_id,
				csrf_test_name: $.cookie('csrf_cookie_name')
			},
			success:function(response) {
				response = JSON.parse(response);
				var current_available_sit = $('#sit_available_number_'+response.table_id).html();
				var cancelled_sit_number = response.persons;
				var new_available_sit = parseInt(current_available_sit)+parseInt(cancelled_sit_number);
				$('#sit_available_number_'+response.table_id).html(new_available_sit);
				// $('#single_notification_row_'+response).remove();
			},
			error:function(){
				alert("error");
			}
		});		
	});
	$('#please_read_table_modal_button').on('click',function(){
		$('#please_read_modal').fadeIn('500');
	});

	$('#please_read_close_button,#please_read_close_button_cross').on('click',function(){
		$('#please_read_modal').fadeOut('500');
	});
	$('#table_modal_cancel_button,#proceed_without_table_button').on('click',function(){
		$('.new_book_to_table').remove();
		$('.single_table_order_details_holder .bottom').css('display','block');
		$('#show_tables_modal2').fadeOut('500');	
		reset_table_modal();
	});
	$(document).on('click','.remove_new_order_row_icon',function(){
		var this_table_id = $(this).attr('id').substr(24);
		$('#new_order_table_'+this_table_id).remove();
		$('#single_table_order_details_bottom_'+this_table_id).css('display','block');
		$('#single_table_order_details_bottom_person_'+this_table_id).val('1');
	});
	$( document ).on( 'keydown', function ( e ) {
		if(e.ctrlKey && e.shiftKey && e.which == 70){
			$('#search').focus();
		}
    });
	var interval;
	$('#notification_list_holder').slimscroll({
		height: '300px'
	}).parent().css({
		background: 'none',
		border: '0px solid #184055'
	});
	$('#kot_list_holder').slimscroll({
		height: '250px'
	}).parent().css({
		background: 'none',
		border: '0px solid #184055'
	});
	
	$('.select_table_modal_info_holder2').slimscroll({
		height: '450px'
	}).parent().css({
		background: 'none',
		border: '0px solid #184055'
	});
	
	$('.help_modal_info_holder').slimscroll({
		height: '400px'
	}).parent().css({
		background: 'none',
		border: '0px solid #184055'
	});
	$('#calculator_button').on('click',function(){
		if($('#calculator_main').css('display')=='none'){
			$('#calculator_main').css('display','block');	
		}else{
			$('#calculator_main').css('display','none');
		}
		
	});
	set_calculator_position();
	$('#kitchen_status_item_details').slimscroll({
		height: '100px'
	}).parent().css({
		background: 'none',
		border: '0px solid #184055'
	});
	$('#notification_remove_all').on('click',function(){
		
		if($('.single_notification_checkbox:checked').length>0){
			var r = confirm("Are you sure to delete all notifications?");
			if (r ==false) {

				return false;
			}
			var notifications = '';
			var j = 1;
			var checkbox_length = $('.single_notification_checkbox:checked').length;
			$('.single_notification_checkbox:checked').each(function(i, obj) {
				if(j==checkbox_length){
					notifications += $(this).val();	
				}else{
					notifications += $(this).val()+',';
				}
				j++;
			});
			if(notifications!=""){
				var notifications_array = notifications.split(",");
				notifications_array.forEach(function(entry) {
				    $('#single_notification_row_'+entry).remove();
				});
				//Then read the values from the array where 0 is the first
				//Since we skipped the first element in the array, we start at 1
				$.ajax({
					url:base_url+"Sale/remove_multiple_notification_ajax",
					method:"POST",
					data:{
						notifications : notifications,
						csrf_test_name: $.cookie('csrf_cookie_name')
					},
					success:function(response) {
						// $('#single_notification_row_'+response).remove();
					},
					error:function(){
						alert("error");
					}
				});
			}			
		}else{
			swal({
				title: 'Alert',
				text: 'No notification is selected',
                confirmButtonColor: '#b6d6f6' 
			});
		}
	});
	$(document).on('click','.single_serve_b',function(){
		var notification_id = $(this).attr('id').substr(26);
		$.ajax({
			url:base_url+"Sale/remove_notication_ajax",
			method:"POST",
			data:{
				notification_id : notification_id,
				csrf_test_name: $.cookie('csrf_cookie_name')
			},
			success:function(response) {
				$('#single_notification_row_'+response).remove();
			},
			error:function(){
				alert("error");
			}
		});	
	});
	$('#select_all_notification').on('change',function(){
		if ($(this).is(':checked')) {
			$('.single_notification_checkbox').prop('checked', true);
		}else{
			$('.single_notification_checkbox').prop('checked', false);
		}
	});
	$('#notification_close').on('click',function(){
		$('#notification_list_modal').fadeOut('500');
		$('.single_notification_checkbox').prop('checked', false);
		$('#select_all_notification').prop('checked', false);
	});
	$('#notification_button').on('click',function(){
		$('#notification_button').css('background-color','#F3F3F3');
		$('#notification_button').css('color','buttontext');
		$('#notification_list_modal').fadeIn('500');
	});
	//when mouse enter on single menu it is animated
	$(document).on('mouseenter','.single_item',function(){
		var that = $(this);
		var item_name_width = Math.ceil(that.find('.item_name').width());
		var item_name_width_half = Math.ceil(item_name_width/2);
		var item_name_width_quartar = Math.ceil(item_name_width_half/2);
		// that.find('.item_name').css('margin-left','-'+item_name_width_half+'px');
		that.find('.item_name').css('margin-left','-100%');
		interval = setInterval(function() {
			// var current_position = parseInt(that.find('.item_name').css('margin-left'));
			var current_position = Math.ceil(parseInt(that.find('.item_name').css('margin-left')));
			if(current_position==-Math.abs(item_name_width_half) || current_position==-Math.abs(item_name_width_half+1) || current_position==-Math.abs(item_name_width_half-1)){
				that.find('.item_name').css('margin-left','0%');	
			}else if(current_position==0){
				that.find('.item_name').css('margin-left','-100%');
			}else if(current_position==item_name_width_quartar || current_position==(item_name_width_quartar+1) || current_position==(item_name_width_quartar-1)){
				that.find('.item_name').css('margin-left','-100%');
			}else{
				that.find('.item_name').css('margin-left','0%');
			}

		},2030);
	});
	$('#open_hold_sales').on('click',function(){
		$('#show_sale_hold_modal').fadeIn('500');
		get_all_hold_sales();
	});
	$(document).on('mouseover','.single_hold_sale,.single_last_ten_sale',function(){
		$(this).css('background-color','#cfcfcf');
	});
	$(document).on('mouseout','.single_hold_sale,.single_last_ten_sale',function(){
		$(this).css('background-color','#ffffff');
		if($(this).attr('data-selected')=='selected'){
			$(this).css('background-color','#cfcfcf');
		}
	});
	$(document).on('click','.single_hold_sale',function(){
		//get hold id
		var hold_id = $(this).attr('id').substr(5);
		$('.single_hold_sale').css('background-color','#ffffff');
		$('.single_hold_sale').attr('data-selected','unselected');
		$(this).css('background-color','#cfcfcf');
		$(this).attr('data-selected','selected');
		//get all info of hold based on hold_id
		$.ajax({
			url:base_url+"Sale/get_single_hold_info_by_ajax",
			method:"POST",
			data:{
				hold_id : hold_id,
				csrf_test_name: $.cookie('csrf_cookie_name')
			},
			success:function(response) {
				response = JSON.parse(response);
				var order_type = '';
				var order_type_id = 0;
				$('#hold_waiter_id').html(response.waiter_id);
				$('#hold_waiter_name').html(response.waiter_name);
				$('#hold_customer_id').html(response.customer_id);
				$('#hold_customer_name').html(response.customer_name);
				$('#hold_table_id').html(response.table_id);
				$('#hold_table_name').html(response.table_name);
				if(response.order_type==1){
					order_type = 'Dine In';
					order_type_id = 1;
				}else if(response.order_type==2){
					order_type = 'Take Away';
					order_type_id = 2;
				}else if(response.order_type==3){
					order_type = 'Delivery';
					order_type_id = 3;
				}
				$('#hold_order_type').html(order_type);
				$('#hold_order_type_id').html(order_type_id);
				var draw_table_for_hold_order='';
				
				for (var key in response.items) {

					//construct div
					var this_item = response.items[key];
					
					var selected_modifiers = '';
					var selected_modifiers_id = '';
					var selected_modifiers_price = '';
					var modifiers_price = 0;
					var total_modifier = this_item.modifiers.length;
					var i = 1;
					for(var mod_key in this_item.modifiers)
					{
						var this_modifier = this_item.modifiers[mod_key];
						//get selected modifiers
				    	if(i == total_modifier){
			    			selected_modifiers += this_modifier.name;
			    			selected_modifiers_id += this_modifier.modifier_id;
			    			selected_modifiers_price += this_modifier.modifier_price;
				    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
				    	}else{
			    			selected_modifiers += this_modifier.name+',';
			    			selected_modifiers_id += this_modifier.modifier_id+',';
				    		selected_modifiers_price += this_modifier.modifier_price+',';
				    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
				    	}
					    i++;
					}
					var discount_value = (this_item.menu_discount_value!="")?this_item.menu_discount_value:'0.00';
					draw_table_for_hold_order += '<div class="single_item_modifier fix" id="hold_order_for_item_'+this_item.food_menu_id+'">';
						draw_table_for_hold_order += '<div class="first_portion fix">';
							draw_table_for_hold_order += '<span class="item_vat_hold" id="hold_item_vat_percentage_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_vat_percentage+'</span>';
							draw_table_for_hold_order += '<span class="item_discount_hold" id="hold_item_discount_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.discount_amount+'</span>';
							draw_table_for_hold_order += '<span class="item_price_without_discount_hold" id="hold_item_price_without_discount_'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_price_without_discount+'</span>';
							draw_table_for_hold_order += '<div class="single_order_column_hold first_column column fix"><span id="hold_item_name_table_'+this_item.food_menu_id+'">'+this_item.menu_name+'</span></div>';
							draw_table_for_hold_order += '<div class="single_order_column_hold second_column column fix">'+currency+' <span id="hold_item_price_table_'+this_item.food_menu_id+'">'+this_item.menu_unit_price+'</span></div>';
							draw_table_for_hold_order += '<div class="single_order_column_hold third_column column fix"><span id="hold_item_quantity_table_'+this_item.food_menu_id+'">'+this_item.qty+'</span></div>';
							draw_table_for_hold_order += '<div class="single_order_column_hold forth_column column fix"><span class="hold_special_textbox" id="hold_percentage_table_'+this_item.food_menu_id+'">'+discount_value+'</span></div>';
							draw_table_for_hold_order += '<div class="single_order_column_hold fifth_column column fix">'+currency+' <span id="hold_item_total_price_table_'+this_item.food_menu_id+'">'+this_item.menu_price_with_discount+'</span></div>';
						draw_table_for_hold_order += '</div>';
						if(selected_modifiers!=""){
							draw_table_for_hold_order += '<div class="second_portion fix">';
								draw_table_for_hold_order += '<span id="hold_item_modifiers_id_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_id+'</span>';
								draw_table_for_hold_order += '<span id="hold_item_modifiers_price_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_price+'</span>';
								draw_table_for_hold_order += '<div class="single_order_column_hold first_column column fix"><span id="hold_item_modifiers_table_'+this_item.food_menu_id+'">'+selected_modifiers+'</span></div>';
								draw_table_for_hold_order += '<div class="single_order_column_hold second_column column fix">'+currency+' <span id="hold_item_modifiers_price_table_'+this_item.food_menu_id+'">'+modifiers_price+'</span></div>';
							draw_table_for_hold_order += '</div>';
						}
						if(this_item.menu_note!=""){
							draw_table_for_hold_order += '<div class="third_portion fix">';
								draw_table_for_hold_order += '<div class="single_order_column_hold first_column column fix">Note: <span id="hold_item_note_table_'+this_item.food_menu_id+'">'+this_item.menu_note+'</span></div>';
							draw_table_for_hold_order += '</div>';	
						}
						
					draw_table_for_hold_order += '</div>';


				}
				//add to top
				$(".item_modifier_details .modifier_item_details_holder").empty();
				$(".item_modifier_details .modifier_item_details_holder").prepend(draw_table_for_hold_order);
				
				var total_items_in_cart_with_quantity = 0;
				$('.detail_hold_sale_holder .modifier_item_details_holder .single_item_modifier .first_portion .third_column span').each(function(i, obj) {
					total_items_in_cart_with_quantity = parseInt(total_items_in_cart_with_quantity)+parseInt($(this).html());
				});
				$('#total_items_in_cart_hold').html(total_items_in_cart_with_quantity);
				var sub_total_discount_hold = (response.sub_total_discount_value!="")?response.sub_total_discount_value:"0.00";
				$("#sub_total_show_hold").html(response.sub_total);
				$("#sub_total_hold").html(response.sub_total);
				$("#total_item_discount_hold").html(response.total_item_discount_amount);
				$("#discounted_sub_total_amount_hold").html(response.sub_total_discount_amount);
				$("#sub_total_discount_hold").html(sub_total_discount_hold);
				$("#sub_total_discount_amount_hold").html(response.sub_total_with_discount);
				$("#all_items_vat_hold").html(response.vat);	
				$("#all_items_discount_hold").html(response.total_discount_amount);
				$("#delivery_charge_hold").html(response.delivery_charge);
				$("#total_payable_hold").html(response.total_payable);
				// $(".order_holder_hold").prepend('<span id="modification_'+sale_id+'" class="modification" style="display:none;">'+sale_id+'</span>');
				//do calculation on table
			},
			error:function(){
				alert("error");
			}
		});
	});
	

	$(document).on('click','.single_last_ten_sale',function(){
		//get sale id
		var sale_id = $(this).attr('id').substr(9);
		$('.single_last_ten_sale').css('background-color','#ffffff');
		$('.single_last_ten_sale').attr('data-selected','unselected');
		$(this).css('background-color','#cfcfcf');
		$(this).attr('data-selected','selected');
		//get all info of sale based on sale_id
		$.ajax({
			url:base_url+"Sale/get_all_information_of_a_sale_ajax",
			method:"POST",
			data:{
				sale_id : sale_id,
				csrf_test_name: $.cookie('csrf_cookie_name')
			},
			success:function(response) {
				response = JSON.parse(response);
				var order_type = '';
				var order_type_id = 0;
				var invoice_type = '';
				var tables_booked = '';
			    if(response.tables_booked.length>0){
			        var w = 1;
			        for (var k in response.tables_booked) {
			        	var single_table = response.tables_booked[k];
			            if(w == response.tables_booked.length){
			                tables_booked += single_table.table_name;
			            }else{
			                tables_booked += single_table.table_name+', ';
			            }
			            w++;
			        }    
			    }else{
			        tables_booked = 'None';
			    }
				$('#last_10_waiter_id').html(response.waiter_id);
				$('#last_10_waiter_name').html(response.waiter_name);
				$('#last_10_customer_id').html(response.customer_id);
				$('#last_10_customer_name').html(response.customer_name);
				$('#last_10_table_id').html(response.table_id);
				$('#last_10_table_name').html(tables_booked);
				if(response.order_type==1){
					order_type = 'Dine In';
					order_type_id = 1;
					invoice_type = 'A ';
				}else if(response.order_type==2){
					order_type = 'Take Away';
					order_type_id = 2;
					invoice_type = 'B ';
				}else if(response.order_type==3){
					order_type = 'Delivery';
					order_type_id = 3;
					invoice_type = 'C ';
				}
				$('#last_10_order_type').html(order_type);
				$('#last_10_order_type_id').html(order_type_id);
				$('#last_10_order_invoice_no').html(invoice_type+''+response.sale_no);
				var draw_table_for_last_ten_sales_order='';
				
				for (var key in response.items) {

					//construct div
					var this_item = response.items[key];
					
					var selected_modifiers = '';
					var selected_modifiers_id = '';
					var selected_modifiers_price = '';
					var modifiers_price = 0;
					var total_modifier = this_item.modifiers.length;
					var i = 1;
					for(var mod_key in this_item.modifiers)
					{
						var this_modifier = this_item.modifiers[mod_key];
						//get selected modifiers
				    	if(i == total_modifier){
			    			selected_modifiers += this_modifier.name;
			    			selected_modifiers_id += this_modifier.modifier_id;
			    			selected_modifiers_price += this_modifier.modifier_price;
				    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
				    	}else{
			    			selected_modifiers += this_modifier.name+',';
			    			selected_modifiers_id += this_modifier.modifier_id+',';
				    		selected_modifiers_price += this_modifier.modifier_price+',';
				    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
				    	}
					    i++;
					}
					var discount_value = (this_item.menu_discount_value!="")?this_item.menu_discount_value:'0.00';
					draw_table_for_last_ten_sales_order += '<div class="single_item_modifier fix" id="last_10_order_for_item_'+this_item.food_menu_id+'">';
						draw_table_for_last_ten_sales_order += '<div class="first_portion fix">';
							draw_table_for_last_ten_sales_order += '<span class="item_vat_hold" id="last_10_item_vat_percentage_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_vat_percentage+'</span>';
							draw_table_for_last_ten_sales_order += '<span class="item_discount_hold" id="last_10_item_discount_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.discount_amount+'</span>';
							draw_table_for_last_ten_sales_order += '<span class="item_price_without_discount_hold" id="last_10_item_price_without_discount_'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_price_without_discount+'</span>';
							draw_table_for_last_ten_sales_order += '<div class="single_order_column_hold first_column column fix"><span id="last_10_item_name_table_'+this_item.food_menu_id+'">'+this_item.menu_name+'</span></div>';
							draw_table_for_last_ten_sales_order += '<div class="single_order_column_hold second_column column fix">'+currency+' <span id="last_10_item_price_table_'+this_item.food_menu_id+'">'+this_item.menu_unit_price+'</span></div>';
							draw_table_for_last_ten_sales_order += '<div class="single_order_column_hold third_column column fix"><span id="last_10_item_quantity_table_'+this_item.food_menu_id+'">'+this_item.qty+'</span></div>';
							draw_table_for_last_ten_sales_order += '<div class="single_order_column_hold forth_column column fix"><span class="hold_special_textbox" id="last_10_percentage_table_'+this_item.food_menu_id+'">'+discount_value+'</span></div>';
							draw_table_for_last_ten_sales_order += '<div class="single_order_column_hold fifth_column column fix">'+currency+' <span id="last_10_item_total_price_table_'+this_item.food_menu_id+'">'+this_item.menu_price_with_discount+'</span></div>';
						draw_table_for_last_ten_sales_order += '</div>';
						if(selected_modifiers!=""){
							draw_table_for_last_ten_sales_order += '<div class="second_portion fix">';
								draw_table_for_last_ten_sales_order += '<span id="last_10_item_modifiers_id_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_id+'</span>';
								draw_table_for_last_ten_sales_order += '<span id="last_10_item_modifiers_price_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_price+'</span>';
								draw_table_for_last_ten_sales_order += '<div class="single_order_column_hold first_column column fix"><span id="last_10_item_modifiers_table_'+this_item.food_menu_id+'">'+selected_modifiers+'</span></div>';
								draw_table_for_last_ten_sales_order += '<div class="single_order_column_hold second_column column fix">'+currency+' <span id="last_10_item_modifiers_price_table_'+this_item.food_menu_id+'">'+modifiers_price+'</span></div>';
							draw_table_for_last_ten_sales_order += '</div>';
						}
						if(this_item.menu_note!=""){
							draw_table_for_last_ten_sales_order += '<div class="third_portion fix">';
								draw_table_for_last_ten_sales_order += '<div class="single_order_column_hold first_column column fix">Note: <span id="last_10_item_note_table_'+this_item.food_menu_id+'">'+this_item.menu_note+'</span></div>';
							draw_table_for_last_ten_sales_order += '</div>';	
						}
						
					draw_table_for_last_ten_sales_order += '</div>';


				}
				//add to top
				$(".item_modifier_details .modifier_item_details_holder").empty();
				$(".item_modifier_details .modifier_item_details_holder").prepend(draw_table_for_last_ten_sales_order);
				var total_items_in_cart_with_quantity = 0;
				$('.last_ten_sales_holder .modifier_item_details_holder .single_item_modifier .first_portion .third_column span').each(function(i, obj) {
					total_items_in_cart_with_quantity = parseInt(total_items_in_cart_with_quantity)+parseInt($(this).html());
				});
				$('#total_items_in_cart_last_10').html(total_items_in_cart_with_quantity);
				var sub_total_discount_last_10 = (response.sub_total_discount_value!="")?response.sub_total_discount_value:"0.00";				
				$("#sub_total_show_last_10").html(response.sub_total);
				$("#sub_total_last_10").html(response.sub_total);
				$("#total_item_discount_last_10").html(response.total_item_discount_amount);
				$("#discounted_sub_total_amount_last_10").html(response.sub_total_discount_amount);
				$("#sub_total_discount_last_10").html(sub_total_discount_last_10);
				$("#sub_total_discount_amount_last_10").html(response.sub_total_with_discount);
				$("#all_items_vat_last_10").html(response.vat);	
				$("#all_items_discount_last_10").html(response.total_discount_amount);
				$("#delivery_charge_last_10").html(response.delivery_charge);
				$("#total_payable_last_10").html(response.total_payable);
				// $(".order_holder_hold").prepend('<span id="modification_'+sale_id+'" class="modification" style="display:none;">'+sale_id+'</span>');
				//do calculation on table
			},
			error:function(){
				alert("error");
			}
		});
	});
	$('#delete_all_hold_sales_button').on('click',function(){
		if($('.detail_hold_sale_holder .single_hold_sale').length>0){

			var r = confirm("Are you sure to delete all hold sales?");
			if (r == true) {
				//delete all information of hold based on hold_id
				$.ajax({
					url:base_url+"Sale/delete_all_holds_with_information_by_ajax",
					method:"POST",
					data:{
						csrf_test_name: $.cookie('csrf_cookie_name')
					},
					success:function(response) {
						if(response==1){
							$('.hold_sale_modal_info_holder .detail_hold_sale_holder .hold_sale_left .detail_holder').empty();	
						}
						
						$('#hold_waiter_id').html('');
						$('#hold_waiter_name').html('');
						$('#hold_customer_id').html('');
						$('#hold_customer_name').html('');
						$('#hold_table_id').html('');
						$('#hold_table_name').html('');
						$('#hold_order_type').html('');
						$('#hold_order_type_id').html('');
						$(".item_modifier_details .modifier_item_details_holder").empty();
						$("#total_items_in_cart_hold").html('0');
						$("#sub_total_show_hold").html('0.00');
						$("#sub_total_hold").html('0.00');
						$("#total_item_discount_hold").html('0.00');
						$("#discounted_sub_total_amount_hold").html('0.00');
						$("#sub_total_discount_hold").html('');
						$("#sub_total_discount_amount_hold").html('0.00');
						$("#all_items_vat_hold").html('0.00');	
						$("#all_items_discount_hold").html('0.00');
						$("#delivery_charge_hold").html('0.00');
						$("#total_payable_hold").html('0.00');
						$('#show_sale_hold_modal').fadeOut('500');
					},
					error:function(){
						alert("error");
					}
				});
			}
		}else{ 
			swal({
                title: "Alert!",
                text: "There is no hold!",
                confirmButtonColor: '#b6d6f6' 
            })	
		}
	});
	$('#hold_delete_button').on('click',function(){
		if($('.single_hold_sale[data-selected=selected]').length>0){
			var hold_id = $('.single_hold_sale[data-selected=selected]').attr('id').substr(5);

			var r = confirm("Are you sure to delete this hold?");
			if (r == true) {
				//delete all information of hold based on hold_id
				$.ajax({
					url:base_url+"Sale/delete_all_information_of_hold_by_ajax",
					method:"POST",
					data:{
						hold_id : hold_id,
						csrf_test_name: $.cookie('csrf_cookie_name')
					},
					success:function(response) {
						get_all_hold_sales();
						$('#hold_waiter_id').html('');
						$('#hold_waiter_name').html('');
						$('#hold_customer_id').html('');
						$('#hold_customer_name').html('');
						$('#hold_table_id').html('');
						$('#hold_table_name').html('');
						$('#hold_order_type').html('');
						$('#hold_order_type_id').html('');
						$(".item_modifier_details .modifier_item_details_holder").empty();
						$("#total_items_in_cart_hold").html('0');
						$("#sub_total_show_hold").html('0.00');
						$("#sub_total_hold").html('0.00');
						$("#total_item_discount_hold").html('0.00');
						$("#discounted_sub_total_amount_hold").html('0.00');
						$("#sub_total_discount_hold").html('');
						$("#sub_total_discount_amount_hold").html('0.00');
						$("#all_items_vat_hold").html('0.00');	
						$("#all_items_discount_hold").html('0.00');
						$("#delivery_charge_hold").html('0.00');
						$("#total_payable_hold").html('0.00');
						// $('#show_sale_hold_modal').fadeOut('500');
					},
					error:function(){
						alert("error");
					}
				});
			}
		}else{ 
			swal({
                title: "Alert!",
                text: "Please select a Hold Sale to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })	
		}
		
	});
	$('#last_ten_delete_button').on('click',function(){
		if($('.single_last_ten_sale[data-selected=selected]').length>0){
			var sale_id = $('.single_last_ten_sale[data-selected=selected]').attr('id').substr(9);
			if(role!='Admin'){

				swal({
					title: 'Alert',
					text: 'Delete is only allowed for Admin',
                	confirmButtonColor: '#b6d6f6'
				});
				return false;
			}else{
				var r = confirm("Are you sure to delete this order?");
				if (r == true) {
				    //delete all information of sale based on sale_id
					$.ajax({
						url:base_url+"Sale/cancel_particular_order_ajax",
						method:"POST",
						data:{
							sale_id : sale_id,
							csrf_test_name: $.cookie('csrf_cookie_name')
						},
						success:function(response) {
							reset_last_10_sales_modal();
							$('#show_last_ten_sales_modal').hide();
						},
						error:function(){
							alert("error");
						}
					});
				}
			}
		}else{ 
			swal({
                title: "Alert!",
                text: "Please select an order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })	
		}
		
	});
	$('#last_ten_print_invoice_button').on('click',function(){
		if($('.single_last_ten_sale[data-selected=selected]').length>0){
			var sale_id = $('.single_last_ten_sale[data-selected=selected]').attr('id').substr(9);
			print_invoice(sale_id);
		}else{ 
			swal({
                title: "Alert!",
                text: "Please select an order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })	
		}
	});
	$('#hold_edit_in_cart_button').on('click',function(){
		var hold_id = $('.single_hold_sale[data-selected=selected]').attr('id').substr(5);
		if($('.single_hold_sale[data-selected=selected]').length>0){
			
			//get total items in cart 
			var total_items_in_cart = $('.order_holder .single_order').length;
			
			if(total_items_in_cart>0){
				var r = confirm("Cart is not empty, want to proceed?");
				if (r == true) {
				    $('.order_holder').empty();
				    clearFooterCartCalculation();
					get_details_of_a_particular_hold(hold_id);
				}
			}else{
				clearFooterCartCalculation();
				get_details_of_a_particular_hold(hold_id);
			}

			
			
		}else{
			swal({
                title: "Alert!",
                text: "Please select a Hold Sale to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })	
		}
	});
	$('#hold_sales_close_button,#hold_sales_close_button_cross').on('click',function(){
		$('#hold_waiter_id').html('');
		$('#hold_waiter_name').html('');
		$('#hold_customer_id').html('');
		$('#hold_customer_name').html('');
		$('#hold_table_id').html('');
		$('#hold_table_name').html('');
		$('#hold_order_type').html('');
		$('#hold_order_type_id').html('');

		$(".item_modifier_details .modifier_item_details_holder").empty();
		$("#total_items_in_cart_hold").html('0');
		$("#sub_total_show_hold").html('0.00');
		$("#sub_total_hold").html('0.00');
		$("#total_item_discount_hold").html('0.00');
		$("#discounted_sub_total_amount_hold").html('0.00');
		$("#sub_total_discount_hold").html('');
		$("#sub_total_discount_amount_hold").html('0.00');
		$("#all_items_vat_hold").html('0.00');	
		$("#all_items_discount_hold").html('0.00');
		$("#delivery_charge_hold").html('0.00');
		$("#total_payable_hold").html('0.00');
		$('#show_sale_hold_modal').fadeOut('500');

	});
	//when mouse out from single menu it stops animating and bring text center
	$(document).on('mouseleave','.single_item',function(){
		var that = $(this);
		that.find('.item_name').css('margin-left','-50%');
		clearInterval(interval);
	});

	//when mouse enter on modal's migration text of it is animated
	$(document).on('mouseenter','.modal_modifiers',function(){
		var that = $(this);
		var item_name_width = Math.ceil(that.find('p').width());
		var item_name_width_half = Math.ceil(item_name_width/2);
		var item_name_width_quartar = Math.ceil(item_name_width_half/2);
		// that.find('.item_name').css('margin-left','-'+item_name_width_half+'px');
		that.find('p').css('margin-left','-100%');
		interval = setInterval(function() {
			// var current_position = parseInt(that.find('.item_name').css('margin-left'));
			var current_position = Math.ceil(parseInt(that.find('p').css('margin-left')));
			if(current_position==-Math.abs(item_name_width_half) || current_position==-Math.abs(item_name_width_half+1) || current_position==-Math.abs(item_name_width_half-1)){
				that.find('p').css('margin-left','0%');	
			}else if(current_position==0){
				that.find('p').css('margin-left','-100%');
			}else if(current_position==item_name_width_quartar || current_position==(item_name_width_quartar+1) || current_position==(item_name_width_quartar-1)){
				that.find('p').css('margin-left','-100%');
			}else{
				that.find('p').css('margin-left','0%');
			}

		},2030);
	});

	//when mouse out from single menu it stops animating and bring text center
/*	$(document).on('mouseleave','.header_part_left_left .outlet_holder .outlet_holder_moving',function(){
		var that = $(this);
		that.find('p').css('margin-left','-50%');
		clearInterval(interval);
	});*/

	$('#create_invoice_and_close,#order_details_create_invoice_close_order_button').on('click',function(){
		
		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
			
			var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
			$.ajax({
				url:base_url+"Sale/get_all_information_of_a_sale_ajax",
				method:"POST",
				data:{
					sale_id : sale_id,
					csrf_test_name: $.cookie('csrf_cookie_name')
				},
				success:function(response) {
					response = JSON.parse(response);
					$('#finalize_total_payable').html(response.total_payable);
					$('#pay_amount_invoice_input').val(response.total_payable);
					$('#finalize_order_modal').show();
					$('#finalize_update_type').html('2');//when 2 update payment method, close time and order_status to 3
					calculate_create_invoice_modal();
				},
				error:function(){
					alert("error");
				}
			});
			
		}else{
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })
		}
	});
	$('#given_amount_input').on('keyup',function(e){
		//if the letter is not digit then display error and don't type anything
		if (e.which != 190 && e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
			$(this).val('');
		}
		//get the value of the delivery charge amount
		var given_amount = ($(this).val()!="")?$(this).val():0;
		
		//check wether value is valid or not
		remove_last_two_digit_without_percentage(given_amount,$(this));
		
		given_amount = ($(this).val()!="")?$(this).val():0;
		var total_payable = $('#finalize_total_payable').html();
		var total_change = (parseFloat(given_amount)-parseFloat(total_payable)).toFixed(2);
		$('#change_amount_input').val(total_change);
	});
	$('#pay_amount_invoice_input').on('keyup',function(e){
		//if the letter is not digit then display error and don't type anything
		if (e.which != 190 && e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
			$(this).val('');
		}
		var paid_amount = ($(this).val()!="")?$(this).val():0;
		
		remove_last_two_digit_without_percentage(paid_amount,$(this));
		calculate_create_invoice_modal();		
	});
	$('#finalize_order_cancel_button').on('click',function(){
		reset_finalize_modal();
		
	});

	//when mouse enter on modal's migration text of it is animated
/*	$(document).on('mouseenter','.header_part_left_left .outlet_holder .outlet_holder_moving',function(){
		var that = $(this);
		var item_name_width = Math.ceil(that.find('p').width());
		var item_name_width_half = Math.ceil(item_name_width/2);
		var item_name_width_quartar = Math.ceil(item_name_width_half/2);
		// that.find('.item_name').css('margin-left','-'+item_name_width_half+'px');
		that.find('p').css('margin-left','-100%');
		interval = setInterval(function() {

			// var current_position = parseInt(that.find('.item_name').css('margin-left'));
			var current_position = Math.ceil(parseInt(that.find('p').css('margin-left')));
			if(current_position==-Math.abs(item_name_width_half) || current_position==-Math.abs(item_name_width_half+1) || current_position==-Math.abs(item_name_width_half-1)){
				that.find('p').css('margin-left','0%');	
			}else if(current_position==0){
				that.find('p').css('margin-left','-100%');
			}else if(current_position==item_name_width_quartar || current_position==(item_name_width_quartar+1) || current_position==(item_name_width_quartar-1)){
				that.find('p').css('margin-left','-100%');
			}else{
				that.find('p').css('margin-left','0%');
			}

		},2030);
	});*/

	//when mouse out from modal's migration text stops animating and bring text center
	$(document).on('mouseleave','.modal_modifiers',function(){
		var that = $(this);
		that.find('p').css('margin-left','-50%');
		clearInterval(interval);
	});

	$("#previous_category").on('click',function(){
		var parent_width = Math.ceil($('.select_category_inside').width());
		var child_width = Math.ceil($('.select_category_inside_inside').width());
		var fixed_to_move = child_width-parent_width;
		var current_position = parseInt($('.select_category_inside_inside').css('margin-left'));
		var updated_position = current_position+50;
		var update_position_unsigned = Math.abs(updated_position);
		if(0>updated_position){
			$('.select_category_inside_inside').css('margin-left',updated_position+'px');
		}else if(0<updated_position){
			$('.select_category_inside_inside').css('margin-left','0px');
		}

	});
	$('#kitchen_status_button').on('click',function(){
		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
			var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
			$.ajax({
				url:base_url+"Sale/get_all_information_of_a_sale_ajax",
				method:"POST",
				data:{
					sale_id : sale_id,
					csrf_test_name: $.cookie('csrf_cookie_name')
				},
				success:function(response) {

					reset_time_interval();
					all_time_interval_operation();
					var order_object = JSON.parse(response);
					var order_type = order_object.order_type;
					var order_number = '';
					var order_type_name = '';
					if(order_type==1){
						order_number = 'A '+order_object.sale_no;
						order_type_name = 'Dine In';
					}else if(order_type==2){
						order_number = 'B '+order_object.sale_no;
						order_type_name = 'Take Away';
					}else if(order_type==3){
						order_number = 'C '+order_object.sale_no;
						order_type_name = 'Delivery';
					}
					var tables_booked = '';
				    if(order_object.tables_booked.length>0){
				        var w = 1;
				        for (var k in order_object.tables_booked) {
				        	var single_table = order_object.tables_booked[k];
				            if(w == order_object.tables_booked.length){
				                tables_booked += single_table.table_name;
				            }else{
				                tables_booked += single_table.table_name+', ';
				            }
				            w++;
				        }    
				    }else{
				        tables_booked = 'None';
				    }
					var waiter_name = (order_object.waiter_name=="" || order_object.waiter_name==null)?"":order_object.waiter_name;
					var customer_name = (order_object.customer_name=="" || order_object.customer_name==null)?"":order_object.customer_name;
					var table_name = (order_object.table_name=="" || order_object.table_name==null)?"":order_object.table_name;
					var order_time = new Date(Date.parse(order_object.date_time));
					var now = new Date();
				
					var  days = parseInt((now - order_time) / (1000 * 60 * 60 * 24));
					var  hours = parseInt(Math.abs(now - order_time) / (1000 * 60 * 60) % 24);
					var  minute = parseInt(Math.abs(now.getTime() - order_time.getTime()) / (1000 * 60) % 60);
					var  second = parseInt(Math.abs(now.getTime() - order_time.getTime()) / (1000) % 60);
					minute = minute.toString();
					second = second.toString();
					minute = (minute.length==1)?'0'+minute:minute;
					second = (second.length==1)?'0'+second:second;

					var order_placed_at = 'Order Placed at: '+order_time.getHours()+':'+order_time.getMinutes()+'';
					var item_list_to_show = '';
					for (var key in order_object.items) {
						var single_item = order_object.items[key];

						if(single_item.item_type=='Kitchen Item'){
							


							var item_name = single_item.menu_name;
							var background_color = '';
							var current_condition = 'In the queue';
							if(single_item.cooking_status=='Started Cooking'){
								var cooking_start_time = new Date(Date.parse(single_item.cooking_start_time));
								var now = new Date();
							
								var  item_days = parseInt((now - cooking_start_time) / (1000 * 60 * 60 * 24));
								var  item_hours = parseInt(Math.abs(now - cooking_start_time) / (1000 * 60 * 60) % 24);
								var  item_minute = parseInt(Math.abs(now.getTime() - cooking_start_time.getTime()) / (1000 * 60) % 60);
								var  item_second = parseInt(Math.abs(now.getTime() - cooking_start_time.getTime()) / (1000) % 60);
								item_minute = item_minute.toString();
								item_second = item_second.toString();
								item_minute = (item_minute.length==1)?'0'+item_minute:item_minute;
								item_second = (item_second.length==1)?'0'+item_second:item_second;

								background_color = 'style="background-color:#ADD8E6;"';
								current_condition = 'Started Cooking '+item_minute+':'+item_second+' Min Ago';
							}else if(single_item.cooking_status=='Done'){
								var cooking_start_time = new Date(Date.parse(single_item.cooking_start_time));
								var now = new Date();
							
								var  item_days = parseInt((now - cooking_start_time) / (1000 * 60 * 60 * 24));
								var  item_hours = parseInt(Math.abs(now - cooking_start_time) / (1000 * 60 * 60) % 24);
								var  item_minute = parseInt(Math.abs(now.getTime() - cooking_start_time.getTime()) / (1000 * 60) % 60);
								var  item_second = parseInt(Math.abs(now.getTime() - cooking_start_time.getTime()) / (1000) % 60);
								item_minute = item_minute.toString();
								item_second = item_second.toString();
								item_minute = (item_minute.length==1)?'0'+item_minute:item_minute;
								item_second = (item_second.length==1)?'0'+item_second:item_second;

								background_color = ' style="background-color:#90EE90;"';
								current_condition = 'Done Cooking '+item_minute+':'+item_second+' Min Ago';
							}
							item_list_to_show += '<div class="kitchen_status_single_item fix" '+background_color+'>';
							item_list_to_show += '<div class="fix first">'+item_name+'</div>';
							item_list_to_show += '<div class="fix second">'+single_item.qty+'</div>';
							item_list_to_show += '<div class="fix third">'+current_condition+'</div>';
							item_list_to_show += '</div>';
						}
					}
					$('#kitchen_status_item_details').empty();
					$('#kitchen_status_order_number').html('');
					$('#kitchen_status_order_number').html(order_number);
					$('#kitchen_status_order_type').html('');
					$('#kitchen_status_order_type').html(order_type_name);
					$('#kitchen_status_waiter_name').html('');
					$('#kitchen_status_waiter_name').html(waiter_name);
					$('#kitchen_status_customer_name').html('');
					$('#kitchen_status_customer_name').html(customer_name);
					$('#kitchen_status_table').html('');
					$('#kitchen_status_table').html(tables_booked);
					$('#kitchen_status_order_placed').html('');
					$('#kitchen_status_order_placed').html(order_placed_at);
					$('#kitchen_status_ordered_minute').html('');
					$('#kitchen_status_ordered_minute').html(minute);
					$('#kitchen_status_ordered_second').html('');
					$('#kitchen_status_ordered_second').html(second);
					$('#kitchen_status_item_details').html(item_list_to_show);

					setInterval(function(){ 
						var s = $('#kitchen_status_ordered_second').text();
						var m = $('#kitchen_status_ordered_minute').text();
						s = parseInt(s);
						m = parseInt(m);
						s++;
						if(s==60){
							m++;
							s=0;
						}
						m = m.toString();
						s = s.toString();
						m = (m.length==1)?'0'+m:m;
						s = (s.length==1)?'0'+s:s;
						$('#kitchen_status_ordered_second').html(s);
						$('#kitchen_status_ordered_minute').html(m);
					}, 1000);
					
				},
				error:function(){
					alert("error");
				}
			});
			
			$('#kitchen_status_modal').show();
			
		}else{
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })
		}
		
	});
	$('#kitchen_status_close_button').on('click',function(){
		$('#kitchen_status_modal').hide();
	});
	$('#help_button').on('click',function(){
		$('#help_modal').fadeIn('500');
	});
	$('#help_close_button,#help_close_button_cross').on('click',function(){
		$('#help_modal').fadeOut('500');
	});
	$('#kitchen_bar_waiter_modal_close_button_cross').on('click',function(){
		$('#kitchen_bar_waiter_panel_button_modal').fadeOut('500');
	});
	$("#next_category").on('click',function(){
		var parent_width = Math.ceil($('.select_category_inside').width());
		var child_width = Math.ceil($('.select_category_inside_inside').width());
		var fixed_to_move = child_width-parent_width;
		var current_position = parseInt($('.select_category_inside_inside').css('margin-left'));
		var updated_position = current_position-50;
		var update_position_unsigned = Math.abs(updated_position);
		if(fixed_to_move>update_position_unsigned){
			$('.select_category_inside_inside').css('margin-left',updated_position+'px');	
		}else{
			$('.select_category_inside_inside').css('margin-left','-'+fixed_to_move+'px');
		}

	});

	//this is to set height when site load
	var height_should_be = parseInt($(window).height())-parseInt($('.top_header_part').height())-20;
	$('.main_left').css('height',height_should_be+'px');
	$('.main_middle').css('height',height_should_be+'px');
	$('.main_right').css('height',height_should_be-10+'px');
	//end

	//load first category's items default at site load
	$(".specific_category_items_holder:first").show('1000');

	//end

	//get all images based on category when category button is clicked		
	$('.category_button').on('click',function(){

		var str = $(this).attr('id');
		var res = str.substr(16);
		$("#searched_item_found").remove();
		$('.specific_category_items_holder').hide('1000');
		$('#category_'+res).show('1000');
	});
	
	//when anything is searched
	$("#search").on('keyup', function (e) {
    	// if (e.keyCode == 13) {
        	var searched_string = $(this).val().trim();
			var foundItems = searchItemAndConstructGallery(searched_string);
	    	var searched_category_items_to_show = '<div id="searched_item_found" class="specific_category_items_holder" style="display:block;">';
			
	    	for (var key in foundItems) {
			    if (foundItems.hasOwnProperty(key)) {
			        searched_category_items_to_show += '<div class="single_item fix" id="item_'+foundItems[key].item_id+'">';
						searched_category_items_to_show += '<p class="item_price">'+foundItems[key].price+'</p>';
						searched_category_items_to_show += '<span class="item_vat_percentage" style="display:none;">'+foundItems[key].vat_percentage+'</span>';
						searched_category_items_to_show += '<img src="'+foundItems[key].image+'" alt="" width="141">';
						searched_category_items_to_show += '<p class="item_name">'+foundItems[key].item_name+' ('+foundItems[key].item_code+')</p>';
					searched_category_items_to_show +='</div>';
			    }
			}
			searched_category_items_to_show +='<div>';
			$("#searched_item_found").remove();
			$('.specific_category_items_holder').hide('1000'); 
	    	$(".category_items").prepend(searched_category_items_to_show);
	    // }
	});

	$('#dine_in_button,#take_away_button,#delivery_button').on('click',function(){
		$('.main_top').find('button').css('background-color','#F3F3F3');
		$(this).css('background-color','#B5D6F6'); 
		$('.main_top').find('button').attr('data-selected','unselected');
		$(this).attr('data-selected','selected');
		$('#table_button').attr('disabled',false);
		if($(this).attr('id')=='dine_in_button'){
		}else if($(this).attr('id')=='take_away_button'){
			$('#table_button').attr('disabled',true);
			$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
			$('.single_table_div[data-table-checked=checked]').css('background-color','#ffffff');
		}else if($(this).attr('id')=='delivery_button'){
			$('#table_button').attr('disabled',true);
			$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
			$('.single_table_div[data-table-checked=checked]').css('background-color','#ffffff');
		}
			
			
			
	});

	//when single ite is clicked pop-up modal is appeared
	$(document).on('click','.single_item',function(){
		var row_number = $('#modal_item_row').html();
		//get item/menu id from modal
		var item_id = $(this).attr('id').substr(5);
		//get item/menu name from modal
		var item_name = $(this).find('.item_name').html();
		//get item/menu vat percentage from modal
		var item_vat_percentage = $(this).find('.item_vat_percentage').html();
		item_vat_percentage = (item_vat_percentage=="")?'0.00':item_vat_percentage;
		//discount amount from modal
		var item_discount_amount = parseFloat(0).toFixed(2);
		
		//discount input value of modal
		var discount_input_value = 0;

		//get item/menu price from modal
		var item_price = (parseFloat($('#price_'+item_id).html())).toFixed(2);

		//get item/menu price from modal without discount
		var item_total_price_without_discount = parseFloat(item_price).toFixed(2);

		//get vat amount for specific item/menu
		var item_vat_amount_for_unit_item = ((parseFloat(item_price)*parseFloat(item_vat_percentage))/parseFloat(100)).toFixed(2);

		//get item/menu total price from modal
		var item_total_price = (parseFloat(item_price)).toFixed(2);

		
		//get item/menu quantity from modal
		var item_quantity = '1';

		//get vat amount for specific item/menu
		var item_vat_amount_for_all_quantity = (parseFloat(item_vat_amount_for_unit_item)*parseFloat(item_quantity)).toFixed(2);

		//get selected modifiers
		var selected_modifiers = '';
		var selected_modifiers_id = '';
		var selected_modifiers_price = '';

		//get modifiers price
		var modifiers_price = parseFloat(0).toFixed(2);
		
		//get note
		var note = '';

		//construct div
		var draw_table_for_order='';
		
		draw_table_for_order += (row_number>0)?'':'<div class="single_order fix" id="order_for_item_'+item_id+'">';
			draw_table_for_order += '<div class="first_portion fix">';
				draw_table_for_order += '<span class="item_previous_id" id="item_previous_id_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_cooking_done_time" id="item_cooking_done_time_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_cooking_start_time" id="item_cooking_start_time_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_cooking_status" id="item_cooking_status_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_type" id="item_type_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_vat" id="item_vat_percentage_table'+item_id+'" style="display:none;">'+item_vat_percentage+'</span>';
				draw_table_for_order += '<span class="item_discount" id="item_discount_table'+item_id+'" style="display:none;">'+item_discount_amount+'</span>';
				draw_table_for_order += '<span class="item_price_without_discount" id="item_price_without_discount_'+item_id+'" style="display:none;">'+item_total_price_without_discount+'</span>';
				draw_table_for_order += '<div class="single_order_column first_column fix"><i style="cursor:pointer;" class="fas fa-pencil-alt edit_item" id="edit_item_'+item_id+'"></i> <span id="item_name_table_'+item_id+'">'+item_name+'</span></div>';
				draw_table_for_order += '<div class="single_order_column second_column fix">'+currency+' <span id="item_price_table_'+item_id+'">'+item_price+'</span></div>';
				draw_table_for_order += '<div class="single_order_column third_column fix"><i style="cursor:pointer;" class="fas fa-minus-circle decrease_item_table" id="decrease_item_table_'+item_id+'"></i> <span id="item_quantity_table_'+item_id+'">'+item_quantity+'</span> <i style="cursor:pointer;" class="fas fa-plus-circle increase_item_table" id="increase_item_table_'+item_id+'"></i></div>';
				draw_table_for_order += '<div class="single_order_column forth_column fix"><input type="" name="" placeholder="Amt or %" class="special_textbox" id="percentage_table_'+item_id+'" value="'+discount_input_value+'" disabled></div>';
				draw_table_for_order += '<div class="single_order_column fifth_column fix">'+currency+' <span id="item_total_price_table_'+item_id+'">'+item_total_price+'</span></div>';
			draw_table_for_order += '</div>';
			if(selected_modifiers!=""){
				draw_table_for_order += '<div class="second_portion fix">';
					draw_table_for_order += '<span id="item_modifiers_id_table_'+item_id+'" style="display:none;">'+selected_modifiers_id+'</span>';
					draw_table_for_order += '<span id="item_modifiers_price_table_'+item_id+'" style="display:none;">'+selected_modifiers_price+'</span>';
					draw_table_for_order += '<div class="single_order_column first_column fix"><span id="item_modifiers_table_'+item_id+'">'+selected_modifiers+'</span></div>';
					draw_table_for_order += '<div class="single_order_column fifth_column fix">'+currency+' <span id="item_modifiers_price_table_'+item_id+'">'+modifiers_price+'</span></div>';
				draw_table_for_order += '</div>';
			}
			if(note!=""){
				draw_table_for_order += '<div class="third_portion fix">';
					draw_table_for_order += '<div class="single_order_column first_column fix">Note: <span id="item_note_table_'+item_id+'">'+note+'</span></div>';
				draw_table_for_order += '</div>';	
			}
			
		draw_table_for_order += (row_number>0)?'':'</div>';
		

		//add to top if new it or update the row
		if(row_number>0){
			$('.order_holder .single_order[data-single-order-row-no='+row_number+']').empty();
			$('.order_holder .single_order[data-single-order-row-no='+row_number+']').html(draw_table_for_order);
		}else{
			$(".order_holder").append(draw_table_for_order);	
		}
		
		
		
		reset_on_modal_close_or_add_to_cart();
		// return false;
		//do calculation on table
		do_addition_of_item_and_modifiers_price();
				
	});
	$('#cancel_button').on('click',function(){
		//get total items in cart 
		var total_items_in_cart = $('.order_holder .single_order').length;
		
		if(total_items_in_cart>0){
			var r = confirm("Cart is not empty, want to clear the cart?");
			if (r == true) {
			    $('.order_table_holder .order_holder').empty();
				clearFooterCartCalculation();
				$('.main_top').find('button').css('background-color','#F3F3F3');
				$('.main_top').find('button').attr('data-selected','unselected');
				$('#table_button').attr('disabled',false);
				$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
				$("#select_waiter").val('').trigger('change');
				$("#walk_in_customer").val('').trigger('change');
			}
		}
	});
	$(document).on('click','.edit_item',function(){
		var single_order_element_object = $(this).parent().parent().parent();
		var row_number = $(this).parent().parent().parent().attr('data-single-order-row-no');
		var menu_id = $(this).attr('id').substr(10);
		var item_name = single_order_element_object.find('#item_name_table_'+menu_id).html();
		var item_price = single_order_element_object.find('#item_price_table_'+menu_id).html();
		var item_vat_percentage = single_order_element_object.find('#item_vat_percentage_table'+menu_id).html();
		var item_discount_input_value = single_order_element_object.find('#percentage_table_'+menu_id).val();
		var item_discount_amount = single_order_element_object.find('#item_discount_table'+menu_id).html();
		var item_price_without_discount = single_order_element_object.find('#item_price_without_discount_'+menu_id).html();
		var item_quantity = single_order_element_object.find('#item_quantity_table_'+menu_id).html();
		var item_price_with_discount = parseFloat(single_order_element_object.find('#item_total_price_table_'+menu_id).html()).toFixed(2);
		var modifiers_price = parseFloat(0).toFixed(2);
		var cooking_status = single_order_element_object.find('#item_cooking_status_table'+menu_id).html();
		if(cooking_status!=""){
			swal({
                title: "Alert!",
                text: "You can not remove or modify any item that is In Progress or Done in Kitchen",
                confirmButtonColor: '#b6d6f6' 
            });
			return false;
		}
		if(single_order_element_object.find('#item_modifiers_price_table_'+menu_id).length>0){
			modifiers_price = parseFloat(single_order_element_object.find('#item_modifiers_price_table_'+menu_id).html()).toFixed(2);
		}
		
		var note = single_order_element_object.find('#item_note_table_'+menu_id).html();

		if(single_order_element_object.find('#item_modifiers_id_table_'+menu_id).length>0){
			var comma_seperted_modifiers_id = single_order_element_object.find('#item_modifiers_id_table_'+menu_id).html();
			var modifiers_id = (comma_seperted_modifiers_id!="")?comma_seperted_modifiers_id.split(","):'';	
		}
		var total_price = (parseFloat(item_price_with_discount)+parseFloat(modifiers_price)).toFixed(2);


		$('#modal_item_row').html(row_number);
		$('#modal_item_id').html(menu_id);
		$('#modal_item_name').html(item_name);
		$('#modal_item_price').html(item_price);
		$('#modal_item_price_variable').html(item_price_with_discount);
		$('#modal_item_price_variable_without_discount').html(item_price_without_discount);
		$('#modal_total_price').html(item_price);
		$('#modal_item_vat_percentage').html(item_vat_percentage);
		$('#modal_discount_amount').html(item_discount_amount);
		$('#item_quantity_modal').html(item_quantity);
		$('#modal_modifier_price_variable').html(modifiers_price);
		$('#modal_discount').val(item_discount_input_value);
		$('#modal_item_note').val(note);
		$('#modal_total_price').html(total_price);
		//add modifiers to pop up associated to menu
		var foundItems = search_by_menu_id(menu_id,window.items);
		var originalMenu = foundItems[0].modifiers;
		var modifiers = '';
		for (var key in originalMenu) {
			var selectedOrNot='unselected';
			var backgroundColor = '';
			if(typeof modifiers_id !== 'undefined' && modifiers_id.includes(originalMenu[key].menu_modifier_id)){
				selectedOrNot = "selected";
				backgroundColor = 'style="background-color:#B5D6F6;"'
			}else{
				selectedOrNot = "unselected";
				backgroundColor = ''
			}
			modifiers += '<div '+backgroundColor+' class="modal_modifiers" data-selected="'+selectedOrNot+'" id="modifier_'+originalMenu[key].menu_modifier_id+'">';
				modifiers +='<span class="modifier_price" style="display:none;">'+originalMenu[key].menu_modifier_price+'</span>';
				modifiers +='<p>'+originalMenu[key].menu_modifier_name+'</p>';
			modifiers += '</div>'
		}
		$("#item_modal .section3").empty();
		$("#item_modal .section3").prepend(modifiers);		
		$('#item_modal').fadeIn('500');
				
	});
	$('#kot_check_all').on('change',function(){
		if ($(this).is(':checked')) {
			$('.kot_item_checkbox').prop('checked', true);
		}else{
			$('.kot_item_checkbox').prop('checked', false);
		}
	});
	$('#close_item_modal').on('click',function(){
		reset_on_modal_close_or_add_to_cart();
	});
	$('#close_add_customer_modal').on('click',function(){
		$('#customer_name_modal').css('border','1px solid #B5D6F6');
		$('#customer_phone_modal').css('border','1px solid #B5D6F6');
		reset_on_modal_close_or_add_customer();
	});
	$(document).on('click','.modal_modifiers',function(){
		if($(this).attr('data-selected')=='unselected'){
			$(this).css('background-color','#B5D6F6');	
			$(this).attr('data-selected','selected');
			//get modifier price when it's selected
			var modifier_price = parseFloat($(this).find('.modifier_price').html()).toFixed(2);
			//get total modifier price
			var total_modifier_price = parseFloat($('#modal_modifier_price_variable').html()).toFixed(2);
			//add current modifier price to total modifier price
			var update_modifier_price = (parseFloat(modifier_price)+parseFloat(total_modifier_price)).toFixed(2);
			//update total modifier price html element
			$('#modal_modifier_price_variable').html(update_modifier_price);

			//update all total with item price
			update_all_total_price();
		}else if($(this).attr('data-selected')=='selected'){
			$(this).css('background-color','#E0E0E0');
			$(this).attr('data-selected','unselected');
			//get modifier price when it's selected
			var modifier_price = parseFloat($(this).find('.modifier_price').html()).toFixed(2);
			//get total modifier price
			var total_modifier_price = parseFloat($('#modal_modifier_price_variable').html()).toFixed(2);
			//add current modifier price to total modifier price
			var update_modifier_price = (parseFloat(total_modifier_price)-parseFloat(modifier_price)).toFixed(2);
			//update total modifier price html element
			$('#modal_modifier_price_variable').html(update_modifier_price);

			//update all total with item price
			update_all_total_price();
		}
	});

	//initialize item list
	show_all_items();

	//show all when all button is clicked
	$(document).on('click','#button_category_show_all',function(){
		$('.specific_category_items_holder').hide();
		var foundItems = searchItemAndConstructGallery('');
		var searched_category_items_to_show = '<div id="searched_item_found" class="specific_category_items_holder" style="display:block;">';

		for (var key in foundItems) {
			if (foundItems.hasOwnProperty(key)) {
				searched_category_items_to_show += '<div class="single_item fix" id="item_'+foundItems[key].item_id+'">';
				searched_category_items_to_show += '<p class="item_price">'+foundItems[key].price+'</p>';
				searched_category_items_to_show += '<img src="'+foundItems[key].image+'" alt="" width="141">';
				searched_category_items_to_show += '<p class="item_name">'+foundItems[key].item_name+' ('+foundItems[key].item_code+')</p>';
				searched_category_items_to_show +='</div>';
			}
		}
		searched_category_items_to_show +='<div>';
		$("#searched_item_found").remove();
		$('.specific_category_items_holder').hide('1000'); 
		$(".category_items").prepend(searched_category_items_to_show);
	});

	$('#increase_item_modal').on('click',function(){
		//get recent item price
		var current_item_price_modal = parseFloat($('#modal_item_price').html()).toFixed(2);
		//get current item quantity
		var current_item_quantity = parseInt($('#item_quantity_modal').html());
		//increase quantity
		current_item_quantity++;
		//update quantity
		$('#item_quantity_modal').html(current_item_quantity);
		
		//update all total with item price
		update_all_total_price();
	});
	$(document).on('dblclick','.holder .order_details > .single_order',function(){
		var sale_id = $(this).attr('id').substr(6);
		get_details_of_a_particular_order_for_modal(sale_id);
	});
	$('#cancel_order_button').on('click',function(){
		

		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
			var selected_order = $('.holder .order_details > .single_order[data-selected=selected]');
			var selected_order_started_cooking_items =  selected_order.attr('data-started-cooking');
			var selected_order_done_cooking_items = selected_order.attr('data-done-cooking');
			if(selected_order_started_cooking_items>0 || selected_order_done_cooking_items>0){
				swal({
	                title: "Alert!",
	                text: "Order is In Progress or Done, you can not cancel it!",
	                confirmButtonColor: '#b6d6f6' 
	            });	
	            return false;

			}
			var r = confirm("Are you sure to cancel this order?");
			if (r == true) {
				var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
				cancel_order(sale_id);
			}else{
				return false;
			}
		}else{
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            });	
		}
	});
	$('#plus_button').on('click',function(){
		$('#add_customer_modal').fadeIn('500');
	});
	$('.modify_order_table_modal').on('click',function(){
		var table_id = $(this).attr('id').substr(19);
		//get total items in cart 
		var total_items_in_cart = $('.order_holder .single_order').length;
		
		if(total_items_in_cart>0){
			var r = confirm("Cart is not empty, want to proceed?");
			if (r == true) {
			    $('.order_holder').empty();
				$.ajax({
					url:base_url+"Sale/get_all_information_of_a_sale_by_table_id_ajax",
					method:"post",
					data:{
						table_id : table_id,
						csrf_test_name: $.cookie('csrf_cookie_name')
					},
					success:function(response) {
						response = JSON.parse(response);
						arrange_info_on_the_cart_to_modify(response);
						$('.single_table_div[data-table-checked=checked]').css('background-color','#ffffff');
						$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
						$('#show_tables_modal').fadeOut('500');
					},
					error:function(){
						alert("error");
					}
				});
			}
		}else{
			$.ajax({
				url:base_url+"Sale/get_all_information_of_a_sale_by_table_id_ajax",
				method:"post",
				data:{
					table_id : table_id,
					csrf_test_name: $.cookie('csrf_cookie_name')
				},
				success:function(response) {
					response = JSON.parse(response);
					arrange_info_on_the_cart_to_modify(response);
					$('.single_table_div[data-table-checked=checked]').css('background-color','#ffffff');
					$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
					$('#show_tables_modal').fadeOut('500');
				},
				error:function(){
					alert("error");
				}
			});
		}
		
		
	});
	$('#table_button,#dine_in_button').on('click',function(){
		if($('.order_table_holder .order_holder > .modification').length>0){
			var sale_id = $('.order_table_holder .order_holder > .modification').html();
			var sale_no = $('.order_table_holder .order_holder > .modification').attr('data-sale-no');
		}
		if (typeof sale_no !== 'undefined') {
			$('#order_number_or_new_text').html(sale_no);
			$('.bottom_order').val(sale_no);
		}else{
			$('#order_number_or_new_text').html('New');
		}
		$('#show_tables_modal2').fadeIn('500');
		$('.bottom_person').val('1');
		$.ajax({
			url:base_url+"Sale/get_all_tables_with_new_status_ajax",
			method:"GET",
			success:function(response) {
				response = JSON.parse(response);
				var table_details = response.table_details;
				var table_availability = response.table_availability;
				
				for (var key in table_details) {
					var table_id = table_details[key].id;
					var orders_table = table_details[key].orders_table;
					var orders_table_number = orders_table.length;
					var tables_modal = '';
					tables_modal += '<div class="single_row header fix">';
	                    tables_modal += '<div class="floatleft fix column first_column">Ord.</div>';
	                    tables_modal += '<div class="floatleft fix column second_column">Time</div>';
	                    tables_modal += '<div class="floatleft fix column third_column">Person</div>';
	                    tables_modal += '<div class="floatleft fix column forth_column">Del</div>';
			        tables_modal += '</div>';
					if(orders_table_number>0){
						for(var key2 in orders_table){
							tables_modal += '<div class="single_row fix">';
								tables_modal += '<div class="floatleft fix column first_column">'+orders_table[key2].sale_no+'</div>';
								tables_modal += '<div class="floatleft fix column second_column">'+orders_table[key2].booked_in_minute+'M</div>';
								tables_modal += '<div class="floatleft fix column third_column">'+orders_table[key2].persons+'</div>';
								tables_modal += '<div class="floatleft fix column forth_column"><i class="fas fa-trash-alt remove_table_order" id="remove_table_order_'+orders_table[key2].id+'"></i></div>';
							tables_modal += '</div>';
			                
						}	
					}
					if($('#single_table_order_details_top_'+table_id+' .new_book_to_table').length>0){
						var new_row = $('#single_table_order_details_top_'+table_id+' .new_book_to_table').html();
						tables_modal += '<div class="single_row fix new_book_to_table" id="new_order_table_'+table_id+'">';
						tables_modal += new_row;
						tables_modal += '</div>';
					}
					$('#single_table_order_details_top_'+table_id).html(tables_modal);
					
				}
				$('.table_image').attr('src',base_url+"assets/images/table_icon2.png");
				for (var key in table_availability) {
					var table_id = table_availability[key].table_id;
					var sit_capacity = $('#sit_capacity_number_'+table_id).html();
					var booked_sit = table_availability[key].persons_number;
					var available_sit = parseInt(sit_capacity)-parseInt(booked_sit);
					$('#sit_available_number_'+table_id).html(available_sit);
					if(booked_sit!=0){
						$('#single_table_info_holder_'+table_id).find('.table_image').attr('src',base_url+"assets/images/table_icon2_blue.png");
					}
				}
			},
			error:function(){
				alert("error");
			}
		});
		
	});
	$('#order_details_close_button').on('click',function(){
		$('#order_detail_modal').fadeOut('500');
	});
	$('#close_order_button,#order_details_close_order_button').on('click',function(){
		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){

			var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
			if($('#open_orders_order_status_'+sale_id).html()=='1'){ 
				swal({
	                title: "Alert!",
	                text: "You can not close an order without invoicing!",
	                confirmButtonColor: '#b6d6f6' 
	            })
	            return false;	
			}
			var r = confirm("Do you want to close this order?");
			
			if (r == true) {
				close_order(sale_id,0);
			}
		
		}else{
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })
		}		
	});
	$('#decrease_item_modal').on('click',function(){
		//get recent item price
		var current_item_price_modal = parseFloat($('#modal_item_price').html()).toFixed(2);
		//get current item quantity
		var current_item_quantity = parseInt($('#item_quantity_modal').html());
		
		//decrease quantity if greater than 1
		if(current_item_quantity>1)
			current_item_quantity--;
		
		//update quantity
		
		$('#item_quantity_modal').html(current_item_quantity);
		//update all total with item price
		update_all_total_price();
	});
	$(document).on('click','.kot_content_column .single_modifier',function(){
		var current_selection = $(this).attr('data-selected');
		if(current_selection=='selected'){
			$(this).attr('data-selected','unselected');
			$(this).css('background-color','#E0E0E0')
		}else if(current_selection=='unselected'){
			$(this).attr('data-selected','selected');
			$(this).css('background-color','#B5D6F6')
		}
	});	
	$('#last_ten_sales_close_button,#last_ten_sales_close_button_cross').on('click',function(){
		$('#show_last_ten_sales_modal').fadeOut('500');
		reset_last_10_sales_modal();
	});
	$( "#customer_dob_modal" ).datepicker({
	    dateFormat:'yy-mm-dd',
	    changeYear: true,
	    changeMonth: true,
	    showMonthAfterYear: true, //this is what you are looking for
	    maxDate:0
	});
	$( "#customer_doa_modal" ).datepicker({
	    dateFormat:'yy-mm-dd',
	    changeYear: true,
	    changeMonth: true,
	    showMonthAfterYear: true, //this is what you are looking for
	    maxDate:0
	});
	$('#last_ten_sales_button').on('click',function(){
		$('#show_last_ten_sales_modal').fadeIn('500');
		$.ajax({
			url:base_url+"Sale/get_last_10_sales_ajax",
			method:"GET",
			success:function(response) {
				var orders = JSON.parse(response);
				var last_10_orders = '';
				for (var key in orders) {
					var order_name = '';
					if(orders[key].order_type=='1'){
						order_name = 'A '+orders[key].sale_no;
					}else if(orders[key].order_type=='2'){
						order_name = 'B '+orders[key].sale_no;
					}else if(orders[key].order_type=='3'){
						order_name = 'C '+orders[key].sale_no;
					}
					var tables_booked = '';
				    if(orders[key].tables_booked.length>0){
				        var w = 1;
				        for (var k in orders[key].tables_booked) {
				        	var single_table = orders[key].tables_booked[k];
				            if(w == orders[key].tables_booked.length){
				                tables_booked += single_table.table_name;
				            }else{
				                tables_booked += single_table.table_name+', ';
				            }
				            w++;
				        }    
				    }else{
				        tables_booked = 'None';
				    }
					var table_name = (orders[key].table_name!=null)?orders[key].table_name:"&nbsp;";
					last_10_orders += '<div class="single_last_ten_sale fix" id="last_ten_'+orders[key].id+'" data-selected="unselected">';
						last_10_orders += '<div class="first_column column fix">'+order_name+'</div>';
                        last_10_orders += '<div class="second_column column fix">'+orders[key].customer_name+'</div>';
                        last_10_orders += '<div class="third_column column fix">'+tables_booked+'</div>';  
                    last_10_orders += '</div>';
				}
				$(".last_ten_sales_holder .hold_list_holder .detail_holder ").empty();
				$(".last_ten_sales_holder .hold_list_holder .detail_holder ").prepend(last_10_orders);
			},
			error:function(){
				alert("error");
			}
		});
	});
	//when add to card button is clicked information goes to table of middle to top
	$('#add_to_cart').on('click',function(){
		var row_number = $('#modal_item_row').html();
		//get item/menu id from modal
		var item_id = $('#modal_item_id').html();
		//remove if it is edited update of previous added item based on id
		// if($('#order_for_item_'+item_id).length>0){
		// 	$('#order_for_item_'+item_id).remove();
		// }
		
		//get item/menu name from modal
		var item_name = $('#modal_item_name').html();
		//get item/menu vat percentage from modal
		var item_vat_percentage = $('#modal_item_vat_percentage').html();
		item_vat_percentage = (item_vat_percentage=="")?'0.00':item_vat_percentage;
		//discount amount from modal
		var item_discount_amount = (parseFloat($('#modal_discount_amount').html())).toFixed(2);
		
		//discount input value of modal
		var discount_input_value = $('#modal_discount').val();

		//get item/menu price from modal
		var item_price = (parseFloat($('#modal_item_price').html())).toFixed(2);

		//get item/menu price from modal without discount
		var item_total_price_without_discount = parseFloat($('#modal_item_price_variable_without_discount').html()).toFixed(2);

		//get vat amount for specific item/menu
		var item_vat_amount_for_unit_item = ((parseFloat(item_price)*parseFloat(item_vat_percentage))/parseFloat(100)).toFixed(2);

		//get item/menu total price from modal
		var item_total_price = (parseFloat($('#modal_item_price_variable').html())).toFixed(2);

		
		//get item/menu quantity from modal
		var item_quantity = $('#item_quantity_modal').html();

		//get vat amount for specific item/menu
		var item_vat_amount_for_all_quantity = (parseFloat(item_vat_amount_for_unit_item)*parseFloat(item_quantity)).toFixed(2);

		//get selected modifiers
		var selected_modifiers = '';
		var selected_modifiers_id = '';
		var selected_modifiers_price = '';
		var j=1;
		$('.modal_modifiers[data-selected=selected]').each(function(i, obj) {
	    	if(j == $('.modal_modifiers[data-selected=selected]').length){
    			selected_modifiers += $(this).find('p').html();
    			selected_modifiers_id += $(this).attr('id').substr(9);
    			selected_modifiers_price += $(this).find('.modifier_price').html();
	    	}else{
    			selected_modifiers += $(this).find('p').html()+',';
    			selected_modifiers_id += $(this).attr('id').substr(9)+',';
	    		selected_modifiers_price += $(this).find('.modifier_price').html()+',';
	    	}
		    j++;
		});
		
		
		//get modifiers price
		var modifiers_price = parseFloat($('#modal_modifier_price_variable').html()).toFixed(2);
		
		//get note
		var note = $('#modal_item_note').val();


		//construct div
		var draw_table_for_order='';
		
		draw_table_for_order += (row_number>0)?'':'<div class="single_order fix" id="order_for_item_'+item_id+'">';
			draw_table_for_order += '<div class="first_portion fix">';
				draw_table_for_order += '<span class="item_previous_id" id="item_previous_id_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_cooking_done_time" id="item_cooking_done_time_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_cooking_start_time" id="item_cooking_start_time_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_cooking_status" id="item_cooking_status_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_type" id="item_type_table'+item_id+'" style="display:none;"></span>';
				draw_table_for_order += '<span class="item_vat" id="item_vat_percentage_table'+item_id+'" style="display:none;">'+item_vat_percentage+'</span>';
				draw_table_for_order += '<span class="item_discount" id="item_discount_table'+item_id+'" style="display:none;">'+item_discount_amount+'</span>';
				draw_table_for_order += '<span class="item_price_without_discount" id="item_price_without_discount_'+item_id+'" style="display:none;">'+item_total_price_without_discount+'</span>';
				draw_table_for_order += '<div class="single_order_column first_column fix"><i style="cursor:pointer;" class="fas fa-pencil-alt edit_item" id="edit_item_'+item_id+'"></i> <span id="item_name_table_'+item_id+'">'+item_name+'</span></div>';
				draw_table_for_order += '<div class="single_order_column second_column fix">'+currency+' <span id="item_price_table_'+item_id+'">'+item_price+'</span></div>';
				draw_table_for_order += '<div class="single_order_column third_column fix"><i style="cursor:pointer;" class="fas fa-minus-circle decrease_item_table" id="decrease_item_table_'+item_id+'"></i> <span id="item_quantity_table_'+item_id+'">'+item_quantity+'</span> <i style="cursor:pointer;" class="fas fa-plus-circle increase_item_table" id="increase_item_table_'+item_id+'"></i></div>';
				draw_table_for_order += '<div class="single_order_column forth_column fix"><input type="" name="" placeholder="Amt or %" class="special_textbox" id="percentage_table_'+item_id+'" value="'+discount_input_value+'" disabled></div>';
				draw_table_for_order += '<div class="single_order_column fifth_column fix">'+currency+' <span id="item_total_price_table_'+item_id+'">'+item_total_price+'</span></div>';
			draw_table_for_order += '</div>';
			if(selected_modifiers!=""){
				draw_table_for_order += '<div class="second_portion fix">';
					draw_table_for_order += '<span id="item_modifiers_id_table_'+item_id+'" style="display:none;">'+selected_modifiers_id+'</span>';
					draw_table_for_order += '<span id="item_modifiers_price_table_'+item_id+'" style="display:none;">'+selected_modifiers_price+'</span>';
					draw_table_for_order += '<div class="single_order_column first_column fix"><span id="item_modifiers_table_'+item_id+'">'+selected_modifiers+'</span></div>';
					draw_table_for_order += '<div class="single_order_column fifth_column fix">'+currency+' <span id="item_modifiers_price_table_'+item_id+'">'+modifiers_price+'</span></div>';
				draw_table_for_order += '</div>';
			}
			if(note!=""){
				draw_table_for_order += '<div class="third_portion fix">';
					draw_table_for_order += '<div class="single_order_column first_column fix">Note: <span id="item_note_table_'+item_id+'">'+note+'</span></div>';
				draw_table_for_order += '</div>';	
			}
			
		draw_table_for_order += (row_number>0)?'':'</div>';
		

		//add to top if new it or update the row
		if(row_number>0){
			$('.order_holder .single_order[data-single-order-row-no='+row_number+']').empty();
			$('.order_holder .single_order[data-single-order-row-no='+row_number+']').html(draw_table_for_order);
		}else{
			$(".order_holder").append(draw_table_for_order);	
		}
		
		
		
		reset_on_modal_close_or_add_to_cart();
		// return false;
		//do calculation on table
		do_addition_of_item_and_modifiers_price();
		

	});
	//when plus sign is clicked in the table
	$(document).on('click','.single_order .first_portion .third_column .increase_item_table',function(){
		var single_order_element_object = $(this).parent().parent().parent();
		//get item id
		var item_id = $(this).attr('id').substr(20);
		
		//get this item quantity
		var item_quantity = $(this).parent().find('span').html();
		
		//get this item's unit price
		var unit_price = $(this).parent().parent().find('.second_column span').html();
		var cooking_status = single_order_element_object.find('#item_cooking_status_table'+item_id).html();
		if(cooking_status!=""){
			swal({
                title: "Alert!",
                text: "You can not remove or modify any item that is In Progress or Done in Kitchen",
                confirmButtonColor: '#b6d6f6' 
            });
			return false;
		}
		//increase item quantity 
		item_quantity++;
		
		//increase item's total price based on unit price and quantity
		var updated_total_price = (parseFloat(item_quantity)*parseFloat(unit_price)).toFixed(2);
		
		//update total price of this item to view
		$(this).parent().parent().find('.item_price_without_discount').html(updated_total_price);
		
		//update quantity of this item to view
		$(this).parent().find('span').html(item_quantity);
		
		//do calculation on update values
		do_addition_of_item_and_modifiers_price();

	});
	//when - sign is clicked in the table
	$(document).on('click','.single_order .first_portion .third_column .decrease_item_table',function(){
		var single_order_element_object = $(this).parent().parent().parent();
		//get item id
		var item_id = $(this).attr('id').substr(20);
		//get this item quantity
		var item_quantity = $(this).parent().find('span').html();
		//get this item's unit price
		var unit_price = $(this).parent().parent().find('.second_column span').html();
		var cooking_status = single_order_element_object.find('#item_cooking_status_table'+item_id).html();
		if(cooking_status!=""){
			swal({
                title: "Alert!",
                text: "You can not remove or modify any item that is In Progress or Done in Kitchen",
                confirmButtonColor: '#b6d6f6' 
            });
			return false;
		}
		//decrease item quantity if greater then 1 or remove full item from table
		if(item_quantity>1){
			//decrease item quantity
			item_quantity--;

			//decrease item's total price based on unit price and quantity
			var updated_total_price = (parseFloat(item_quantity)*parseFloat(unit_price)).toFixed(2);
			
			//update total price of this item to view
			$(this).parent().parent().find('.item_price_without_discount').html(updated_total_price);
			
			//update quantity of this item to view
			$(this).parent().find('span').html(item_quantity);
			
			//do calculation on update values
			do_addition_of_item_and_modifiers_price();

		}else{
			$('#order_for_item_'+item_id).remove();
			// clearFooterCartCalculation();
			do_addition_of_item_and_modifiers_price();
		}
		//decrease item's total price bsed on unit price and quantity

	});
	
	//add discount for specific item
	$(document).on('keyup','.single_order .first_portion .forth_column input',function(e){
		//if the letter is not digit then display error and don't type anything
		if (e.which != 190 && e.which != 16 && e.which != 53 && e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
			$(this).val('');
		}
		do_addition_of_item_and_modifiers_price();


	});
	$('#print_kot_modal').on('click',function(){
		var order_number = $('#kot_modal_order_number').html();
		var order_date = $('#kot_modal_order_date').html();
		var customer_name = $('#kot_modal_customer_name').html();
		var table_name = $('#kot_modal_table_name').html(); 
		var waiter_name = $('#kot_modal_waiter_name').html(); 
		var order_type = $('#kot_modal_order_type').html(); 
		


		var order_info = '{';
		order_info += '"order_number":"'+order_number+'",';
		order_info += '"order_date":"'+order_date+'",';
		order_info += '"customer_name":"'+customer_name+'",';
		order_info += '"table_name":"'+table_name+'",';
		order_info += '"waiter_name":"'+waiter_name+'",';
		order_info += '"order_type":"'+order_type+'",';
		var items_info = '';
		items_info += '"items":';
		items_info += "[";

		var order_details_id = '';
		var j = 1;
		var checkbox_length = $('.single_kot_row .kot_check_column .kot_item_checkbox:checked').length;
		$('.single_kot_row .kot_check_column .kot_item_checkbox:checked').each(function(i, obj) {
			if(j==checkbox_length){
				order_details_id += $(this).val();	
			}else{
				order_details_id += $(this).val()+',';
			}
			j++;
		});
		if(order_details_id!=""){
			var order_details_id_array = order_details_id.split(",");
			k=1;
			item_array_length = order_details_id_array.length;
			order_details_id_array.forEach(function(entry) {
			    var single_kot_row = $('#kot_for_item_'+entry);
			    var kot_item_name = single_kot_row.find('.kot_item_name_column').html();
			    var kot_item_qty = $('#kot_modal_item_qty_'+entry).html();
				
				items_info += '{"kot_item_name":"'+kot_item_name+'", "kot_item_qty":"'+kot_item_qty+'"';
				var modifiers = '';
				var m = 1;
				$('.single_modifier[data-item-detail-id='+entry+'][data-selected=selected]').each(function(i, obj) {
					if(m==$('.single_modifier[data-item-detail-id='+entry+'][data-selected=selected]').length){
						modifiers += $(this).html();
					}else{
						modifiers += $(this).html()+',';
					}
					
					m++;
				});
				items_info += ',"modifiers":"'+modifiers+'"';
				items_info += (k==item_array_length)?'}':'},';
				k++;
			});
		}
		items_info += "]";
		order_info += items_info+'}';

		var order_object = JSON.stringify(order_info);

		$.ajax({
			url:base_url+"Sale/add_temp_kot_ajax",
			method:"POST",
			data:{
				order : order_object,
				csrf_test_name: $.cookie('csrf_cookie_name')
			},
			success:function(response) {
				if(response>0){
					$('#kot_list_modal').fadeOut('500');
					let newWindow = open("print_temp_kot/"+response, 'Print KOT', 'width=450,height=550')
					newWindow.focus();

					newWindow.onload = function() {
					  newWindow.document.body.insertAdjacentHTML('afterbegin');
					};
				}

			},
			error:function(){
				alert("error");
			}
		});






		
	});
	//add discount for specific item in modal
	$(document).on('keyup','#modal_discount',function(e){
		//if the letter is not digit then display error and don't type anything
		if (e.which != 190 && e.which != 16 && e.which != 53 && e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
			$(this).val('');
		}
		update_all_total_price();
	});
	$('#sub_total_discount').on('keyup',function(e){
		//if the letter is not digit then display error and don't type anything
		if (e.which != 190 && e.which != 16 && e.which != 53 && e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
			$(this).val('');
		}
		do_addition_of_item_and_modifiers_price();
	});
	$('#delivery_charge').on('keyup',function(e){
		//if the letter is not digit then display error and don't type anything
		if (e.which != 190 && e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
			$(this).val('');
		}
		do_addition_of_item_and_modifiers_price();
	});
	
	$("#walk_in_customer").select2({dropdownCssClass : 'bigdrop'}); 
	$('#place_order_operation').on('click',function(){
		
		var sale_id = 0;
		if($('.order_table_holder .order_holder > .modification').length>0){
			var sale_id = $('.order_table_holder .order_holder > .modification').html();
		}
		var selected_order_type_object = $('.main_top').find('button[data-selected=selected]');
		var total_items_in_cart = $('.order_holder .single_order').length;
		var sub_total = parseFloat($('#sub_total_show').html()).toFixed(2);
		var total_vat = parseFloat($('#all_items_vat').html()).toFixed(2);
		var total_payable = parseFloat($('#total_payable').html()).toFixed(2);
		var total_item_discount_amount = parseFloat($('#total_item_discount').html()).toFixed(2);
		var sub_total_with_discount = parseFloat($('#discounted_sub_total_amount').html()).toFixed(2);
		var sub_total_discount_amount = parseFloat($('#sub_total_discount_amount').html()).toFixed(2);
		var total_discount_amount = parseFloat($('#all_items_discount').html()).toFixed(2);
		var delivery_charge = ($('#delivery_charge').val()!="")?parseFloat($('#delivery_charge').val()).toFixed(2):parseFloat(0).toFixed(2);
		var sub_total_discount_value = $('#sub_total_discount').val();
		var sub_total_discount_type = '';
		var customer_id = $('#walk_in_customer').val();
		var waiter_id = $('#select_waiter').val();
		if(total_items_in_cart==0){
			swal({
                title: "Alert!",
                text: "Cart is empty!",
                confirmButtonColor: '#b6d6f6' 
            })
			return false;
		}
		if(sub_total_discount_value.length>0 && sub_total_discount_value.substr(sub_total_discount_value.length - 1)=='%'){
			sub_total_discount_type = 'percentage';
		}else{
			sub_total_discount_type= 'plain'; 
		}
		// var selected_table = 0;
		
		// if($(".single_table_div[data-table-checked=checked]").length>0){
		// 	selected_table = $(".single_table_div[data-table-checked=checked]").attr('id').substr(13);//1; //demo 	
		// }
		
		if(selected_order_type_object.length>0){
			var order_type = 1;
			if(selected_order_type_object.attr('id')=='delivery_button'){
				order_type = 3;
				if(customer_id==""){ 
					swal({
		                title: "Alert!",
		                text: "Please select A Customer!",
		                confirmButtonColor: '#b6d6f6' 
		            })
					return false;
				}
				if(customer_id=='1'){
					swal({
		                title: "Alert!",
		                text: "Delivery is not possible for Walk-in Customer, please choose another!",
		                confirmButtonColor: '#b6d6f6' 
		            })
					return false;
				}
				
				var address_available = searchCustomerAddress(customer_id);
				if(address_available[0].customer_address==""){ 
					swal({
		                title: "Alert!",
		                text: "For Delivery order, customer must has a Delivery Address!",
		                confirmButtonColor: '#b6d6f6' 
		            })
					return false;
				}

			}else if(selected_order_type_object.attr('id')=='dine_in_button'){
				order_type = 1;
				if(waiter_id==""){ 
					swal({
		                title: "Alert!",
		                text: "Please select A Waiter!",
		                confirmButtonColor: '#b6d6f6' 
		            })
					return false;
				}
				if(customer_id==""){ 
					swal({
		                title: "Alert!",
		                text: "Please select A Customer!",
		                confirmButtonColor: '#b6d6f6' 
		            })
					return false;
				}
				// if(selected_table==0 && sale_id==0){
				// 	swal({
		  //               title: "Alert!",
		  //               text: "Please select a Table!",
		  //               confirmButtonColor: '#b6d6f6' 
		  //           })

				// 	return false;
				// }
				
			}else if(selected_order_type_object.attr('id')=='take_away_button'){
				order_type = 2;
				
				if(waiter_id==""){
					swal({
		                title: "Alert!",
		                text: "Please select A Waiter!",
		                confirmButtonColor: '#b6d6f6' 
		            })
					return false;
				}
				if(customer_id==""){ 
					swal({
		                title: "Alert!",
		                text: "Please select A Customer!",
		                confirmButtonColor: '#b6d6f6' 
		            })
					return false;
				}
			}

			

			var order_status = 1;



			var order_info = '{';
			order_info += '"customer_id":"'+customer_id+'",';
			order_info += '"waiter_id":"'+waiter_id+'",';
			order_info += '"total_items_in_cart":"'+total_items_in_cart+'",';
			order_info += '"sub_total":"'+sub_total+'",';
			order_info += '"total_vat":"'+total_vat+'",';
			order_info += '"total_payable":"'+total_payable+'",';
			order_info += '"total_item_discount_amount":"'+total_item_discount_amount+'",';
			order_info += '"sub_total_with_discount":"'+sub_total_with_discount+'",';
			order_info += '"sub_total_discount_amount":"'+sub_total_discount_amount+'",';
			order_info += '"total_discount_amount":"'+total_discount_amount+'",';
			order_info += '"delivery_charge":"'+delivery_charge+'",';
			order_info += '"sub_total_discount_value":"'+sub_total_discount_value+'",';
			order_info += '"sub_total_discount_type":"'+sub_total_discount_type+'",';
			// order_info += '"selected_table":"'+selected_table+'",';
			order_info += '"order_type":"'+order_type+'",';
			order_info += '"order_status":"'+order_status+'",';
			var orders_table = '';
			orders_table += '"orders_table":';
			orders_table += "[";
			var x = 1;
			var total_orders_table = $('.new_book_to_table').length;
			$('.new_book_to_table').each(function(i, obj) {
				var table_id = $(this).attr('id').substr(16);
				var person = $(this).find('.third_column').html();
					if(x==total_orders_table){
						orders_table += '{"table_id":"'+table_id+'", "persons":"'+person+'"}';
					}else{
						orders_table += '{"table_id":"'+table_id+'", "persons":"'+person+'"},';	
					}
					
				x++;
			});
			
			orders_table += "],";
			order_info += orders_table;
			var items_info = '';
			items_info += '"items":';
			items_info += "[";

			if($('.order_holder .single_order').length>0){
				var k = 1;
				$('.order_holder .single_order').each(function(i, obj) {
					var item_id = $(this).attr('id').substr(15);
					var item_name = $(this).find('#item_name_table_'+item_id).html();
					var item_vat = $(this).find('.item_vat').html();
					var item_discount = $(this).find('#percentage_table_'+item_id).val();
					var discount_type = '';
					if(item_discount.length>0 && item_discount.substr(item_discount.length - 1)=='%'){
						discount_type = 'percentage';
					}else{
						discount_type= 'plain'; 
					}
					var item_previous_id = $(this).find('#item_previous_id_table'+item_id).html();
					var item_cooking_done_time = $(this).find('#item_cooking_done_time_table'+item_id).html();
					var item_cooking_start_time = $(this).find('#item_cooking_start_time_table'+item_id).html();
					var item_cooking_status = $(this).find('#item_cooking_status_table'+item_id).html();
					var item_type = $(this).find('#item_type_table'+item_id).html();
					var item_price_without_discount = $(this).find('.item_price_without_discount').html();
					var item_unit_price = $(this).find('#item_price_table_'+item_id).html();
					var item_quantity = $(this).find('#item_quantity_table_'+item_id).html();
					var item_price_with_discount = $(this).find('#item_total_price_table_'+item_id).html();
					var item_discount_amount = (parseFloat(item_price_without_discount)-parseFloat(item_price_with_discount)).toFixed(2);
					

					items_info += '{"item_id":"'+item_id+'", "item_name":"'+item_name+'", "item_vat":"'+item_vat+'",';
					items_info += '"item_discount":"'+item_discount+'","discount_type":"'+discount_type+'","item_price_without_discount":"'+item_price_without_discount+'",';
					items_info += '"item_unit_price":"'+item_unit_price+'","item_quantity":"'+item_quantity+'",';
					items_info += '"item_previous_id":"'+item_previous_id+'","item_cooking_done_time":"'+item_cooking_done_time+'",';
					items_info += '"item_cooking_start_time":"'+item_cooking_start_time+'","item_cooking_status":"'+item_cooking_status+'","item_type":"'+item_type+'",';
					items_info += '"item_price_with_discount":"'+item_price_with_discount+'","item_discount_amount":"'+item_discount_amount+'"';

					if($(this).find('.second_portion').length>0){
						var modifiers_id = $(this).find('#item_modifiers_id_table_'+item_id).html();
						var modifiers_price = $(this).find('#item_modifiers_price_table_'+item_id).html();
						items_info += ',"modifiers_id":"'+modifiers_id+'", "modifiers_price":"'+modifiers_price+'"';
					}else{
						items_info += ',"modifiers_id":"", "modifiers_price":""';
					}
					if($(this).find('.third_portion').length>0){
						var item_note = $(this).find('#item_note_table_'+item_id).html();
						items_info += ',"item_note":"'+item_note+'"';
					}else{
						items_info += ',"item_note":""';
					}
					items_info += (k==$('.order_holder .single_order').length)?'}':'},';
					k++;
				});	
			}
			items_info += "]";
			order_info += items_info+'}';

			var order_object = JSON.stringify(order_info); 



			add_sale_by_ajax(order_object,sale_id);

			
		}else{ 
			swal({
                title: "Alert!",
                text: "You must select Dine In or Take Away or Delivery!",
                confirmButtonColor: '#b6d6f6' 
            })
		}
	});
	$('#print_kot').on('click',function(){
		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
			var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
			get_details_of_a_particular_order_for_kot_modal(sale_id);
			$('#kot_check_all').prop('checked', true);
			$('#kot_list_modal').fadeIn('500');
			
		}else{ 
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })
		}
	});
	$('#order_details_print_kot_button').on('click',function(){
		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
			var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
			print_kot(sale_id);
		}else{ 
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })
		}
	});
	$(document).on('click','.decrease_item_kot_modal',function(){
		var item_detail_id = $(this).attr('id').substr(24);
		var qty_element = $('#kot_modal_item_qty_'+item_detail_id);
		var qty_element_fixed = $('#kot_modal_item_qty_fixed_'+item_detail_id);
		var qty = parseInt(qty_element.html());
		if(qty>1){
			qty--;
		}
		qty_element.html(qty);
	});
	$(document).on('click','.increase_item_kot_modal',function(){
		var item_detail_id = $(this).attr('id').substr(24);
		var qty_element = $('#kot_modal_item_qty_'+item_detail_id);
		var qty_element_fixed = $('#kot_modal_item_qty_fixed_'+item_detail_id);
		var qty = parseInt(qty_element.html());
		var qty_fixed = parseInt(qty_element_fixed.html());
		if(qty<qty_fixed){
			qty++;	
		}
		
		qty_element.html(qty);
	});
	$('#cancel_kot_modal').on('click',function(){
		$('#kot_check_all').prop('checked', false);
		$('#kot_modal_modified_or_not').hide();
		$('#kot_list_modal').fadeOut('500');
	});
	$('#print_invoice,#order_details_create_invoice_button').on('click',function(){
		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
			
			var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
			$.ajax({
				url:base_url+"Sale/get_all_information_of_a_sale_ajax",
				method:"POST",
				data:{
					sale_id : sale_id,
					csrf_test_name: $.cookie('csrf_cookie_name')
				},
				success:function(response) {
					response = JSON.parse(response);
					$('#finalize_total_payable').html(response.total_payable);
					$('#pay_amount_invoice_input').val(response.total_payable);
					$('#finalize_order_modal').show();
					$('#finalize_update_type').html('1');//when 1 just update payment method and order status to 2 invoice order
					calculate_create_invoice_modal();
				},
				error:function(){
					alert("error");
				}
			});
			
		}else{
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })
		}
	
		// if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
		// 	var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
		// 	print_invoice(sale_id);
		// }else{
		// 	swal({
  //               title: "Alert!",
  //               text: "Please select an Open Order to proceed!",
  //               confirmButtonColor: '#b6d6f6' 
  //           })
		// }
	});
	$('#finalize_order_button').on('click',function(){
		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
			var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
			var payment_method_type = $('#finalie_order_payment_method').val();
			var paid_amount = $('#pay_amount_invoice_input').val();
			var due_amount = $('#due_amount_invoice_input').val();
			var invoice_create_type = $('#finalize_update_type').html();
			if(payment_method_type==""){
				$('#finalie_order_payment_method').css('border','1px solid red');
				return false;
			}
			print_invoice_and_close(sale_id,payment_method_type,invoice_create_type,paid_amount,due_amount);
			reset_finalize_modal();
		}else{
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })
		}
	});
	$('#add_customer').on('click',function(){
		var customer_name = $('#customer_name_modal').val();
		var customer_phone = $('#customer_phone_modal').val();
		var customer_email = $('#customer_email_modal').val();
		var customer_dob = $('#customer_dob_modal').val();
		var customer_doa = $('#customer_doa_modal').val();
		var customer_delivery_address = $('#customer_delivery_address_modal').val();
		var error = 0;
		
		$('#customer_name_modal').css('border','1px solid #B5D6F6');
		$('#customer_phone_modal').css('border','1px solid #B5D6F6');
		
		if(customer_name==""){
			$('#customer_name_modal').css('border','1px solid red');
			error++;
		} 
		
		if(customer_phone==""){
			$('#customer_phone_modal').css('border','1px solid red');
			error++;
		}
		if(error!=0){
			return false;
		}
		$.ajax({
			url:base_url+"Sale/add_customer_by_ajax",
			method:"POST",
			data:{
				customer_name: customer_name,
				customer_phone: customer_phone,
				customer_email: customer_email,
				customer_dob: customer_dob,
				customer_doa: customer_doa,
				customer_delivery_address: customer_delivery_address,
				csrf_test_name: $.cookie('csrf_cookie_name')
			},
			success:function(response) {
				if(response>0){
					$.ajax({
						url:base_url+"Sale/get_all_customers_for_this_user",
						method:"GET",
						success:function(response) {
							response = JSON.parse(response);
							$option_customers = '';
							var i=1;
							var selected_id = '';
							var selected_name = '';
							for (var key in response) {
								
								if(i==response.length){
									// console.log(response[key].id+' '+response[key].name);
									// selected_id = response[key].id;
									// selected_name = response[key].name;
									$option_customers += '<option value="'+response[key].id+'" selected>'+response[key].name+' '+response[key].phone+'</option>';
									// var new_customer = {customer_id:+'"'+response[key].id+'"'+,customer_name:+'"'+response[key].name+'"'+,customer_address:+'"'+response[key].address+'"'};
									var new_customer = {
									    "customer_id" : response[key].id,    //your artist variable
									    "customer_name" : response[key].name,   //your title variable
									    "customer_address" : response[key].address   //your title variable
									};
									window.customers.push(new_customer);
								}else{
									$option_customers += '<option value="'+response[key].id+'">'+response[key].name+' '+response[key].phone+'</option>';	
								}
								i++;
							}
							$('#walk_in_customer').html($option_customers);
							// $('#walk_in_customer').select2('data', {id: selected_id, text: selected_name});
							reset_on_modal_close_or_add_customer();
						},
						error:function(){
							alert("error");
						}
					});
				}
			},
			error:function(){
				alert("error");
			}
		});

		return false;
		

	});
	

});

//update all price of modal 
function update_all_total_price(){
	//get item quantity
	var item_quantity = parseFloat($('#item_quantity_modal').html()).toFixed(2);
	//get item unit price
	var item_unit_price = parseFloat($('#modal_item_price').html()).toFixed(2);
	//get item total price without discount 
	var item_total_price_without_discount = (parseFloat(item_quantity)*parseFloat(item_unit_price)).toFixed(2);
	//set item total price without discount
	$('#modal_item_price_variable_without_discount').html(item_total_price_without_discount);

	//get discount from modal
	var discount_on_modal = $('#modal_discount').val();
	discount_on_modal = (discount_on_modal!="")?discount_on_modal:0;
	
	//remove last digits if number is more than 2 digits after decimal
	remove_last_two_digit_with_percentage(discount_on_modal,$('#modal_discount'));
	
	//get discount actual amount on item price
	var actual_modal_discount_amount = get_particular_item_discount_amount(discount_on_modal,item_total_price_without_discount);

	//set blank if discount amount is more than item total price without discount
	if(parseFloat(actual_modal_discount_amount)>parseFloat(item_total_price_without_discount)){
		$('#modal_discount').val('');
		actual_modal_discount_amount = parseFloat(0).toFixed(2);
	}


	//set actual discount amouto hidden modal element
	$('#modal_discount_amount').html(parseFloat(actual_modal_discount_amount).toFixed(2));

	//get item price after discount
	var item_price_after_discount = (parseFloat(item_total_price_without_discount)-parseFloat(actual_modal_discount_amount)).toFixed(2);

	//set item total price with discount
	$('#modal_item_price_variable').html(item_price_after_discount);	

	//get modifiers price
	var modifier_price = parseFloat($('#modal_modifier_price_variable').html()).toFixed(2);
	
	//add items and modifiers price
	var all_price = (parseFloat(item_price_after_discount)+parseFloat(modifier_price)).toFixed(2);
	
	//show to all total
	$('#modal_total_price').html(all_price);
}

// ==================================================
function show_all_items() {
	$('.specific_category_items_holder').hide();
	setTimeout(function() {
		var foundItems = searchItemAndConstructGallery('');
		var searched_category_items_to_show = '<div id="searched_item_found" class="specific_category_items_holder" style="display:block;">';

		for (var key in foundItems) {
			if (foundItems.hasOwnProperty(key)) {
				searched_category_items_to_show += '<div class="single_item fix" id="item_'+foundItems[key].item_id+'">';
				searched_category_items_to_show += '<p class="item_price">'+foundItems[key].price+'</p>';
				searched_category_items_to_show += '<span class="item_vat_percentage" style="display:none;">'+foundItems[key].vat_percentage+'</span>';
				searched_category_items_to_show += '<img src="'+foundItems[key].image+'" alt="" width="141">';
				searched_category_items_to_show += '<p class="item_name">'+foundItems[key].item_name+' ('+foundItems[key].item_code+')</p>';
				searched_category_items_to_show +='</div>';
			}
		}
		searched_category_items_to_show +='<div>';
		$("#searched_item_found").remove();
		$('.specific_category_items_holder').hide('1000'); 
		$(".category_items").prepend(searched_category_items_to_show);

	},100);
	
	//call this function to adjust the height of left side order list
	adjust_left_side_order_list();
	
	//call this function to adjust the height of right side item list
	adjust_right_side_item_list();


	adjust_middle_side_cart_list();
	$('.single_table_div').on('click',function(){
		if($(this).attr('data-table-checked')!='busy'){

			$('.single_table_div[data-table-checked=checked],.single_table_div[data-table-checked=unchecked]').attr('data-table-checked','unchecked');
			$('.single_table_div[data-table-checked=checked],.single_table_div[data-table-checked=unchecked]').css('background-color','#ffffff');
			$(this).css('background-color','#b6d6f6');
			$(this).attr('data-table-checked','checked');	
		}
		
	});
	$('#close_select_table_modal').on('click',function(){
		
		$('.single_table_div[data-table-checked=checked]').css('background-color','#ffffff');
		$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
		$('#show_tables_modal').fadeOut('500');

	});
	$('#selected_table_done').on('click',function(){
		$('#show_tables_modal').fadeOut('500');
	});
	$('#refresh_order').on('click',function(){
		$(this).css('color','#495057');
		$('#stop_refresh_for_search').html('yes');
		set_new_orders_to_view_for_interval();
	});
	$(document).on('click','.holder .order_details .single_order',function(){
		var sale_id = $(this).attr('id').substr(6);
		$('.holder .order_details .single_order').attr('data-selected','unselected');
		$('.holder .order_details .single_order').css('background-color','#ffffff');
		$(this).attr('data-selected','selected');
		$(this).css('background-color','#b6d6f6');
		$('#refresh_order').css('color','#dc3545');
	});
	$('#modify_order').on('click',function(){

		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
			
			//get total items in cart 
			var total_items_in_cart = $('.order_holder .single_order').length;
			
			if(total_items_in_cart>0){
				var r = confirm("Cart is not empty, want to proceed?");
				if (r == true) {
				    $('.order_holder').empty();
					var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
					get_details_of_a_particular_order(sale_id);
				}
			}else{
				var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
				get_details_of_a_particular_order(sale_id);
			}
			
		}else{
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })
		}
	});
	$('#single_order_details').on('click',function(){
		if($('.holder .order_details > .single_order[data-selected=selected]').length>0){
			var sale_id = $('.holder .order_details .single_order[data-selected=selected]').attr('id').substr(6);
			get_details_of_a_particular_order_for_modal(sale_id);
			
		}else{
			swal({
                title: "Alert!",
                text: "Please select an Open Order to proceed!",
                confirmButtonColor: '#b6d6f6' 
            })
		}
	});
	$('#hold_sale').on('click',function(){
		if($('.order_holder .single_order').length>0){
			$.ajax({
				url:base_url+"Sale/get_new_hold_number_ajax",
				method:"GET",
				success:function(response) {
					$('#generate_sale_hold_modal').show();
					$('#hold_generate_input').val(response);
				},
				error:function(){
					alert("error");
				}
			});
			
		}else{ 
			swal({
                title: "Alert!",
                text: "Cart is empty!",
                confirmButtonColor: '#b6d6f6' 
            })	
		}
		// $('#show_sale_hold_modal').show();
	});
	$('#close_hold_modal').on('click',function(){
		$('#generate_sale_hold_modal').hide();
		$('#hold_generate_input').val('');
		$('#hold_generate_input').css('border','1px solid #a0a0a0');

	});
	$('#hold_cart_info').on('click',function(){
		var hold_number = $('#hold_generate_input').val();
		if(hold_number==""){
			$('#hold_generate_input').css('border','1px solid #dc3545');
			return false;
		}else{
			$('#hold_generate_input').css('border','1px solid #a0a0a0');
		}
		var selected_order_type_object = $('.main_top').find('button[data-selected=selected]').attr('data-selected','unselected');
		var total_items_in_cart = $('.order_holder .single_order').length;
		var sub_total = parseFloat($('#sub_total_show').html()).toFixed(2);
		var total_vat = parseFloat($('#all_items_vat').html()).toFixed(2);
		var total_payable = parseFloat($('#total_payable').html()).toFixed(2);
		var total_item_discount_amount = parseFloat($('#total_item_discount').html()).toFixed(2);
		var sub_total_with_discount = parseFloat($('#discounted_sub_total_amount').html()).toFixed(2);
		var sub_total_discount_amount = parseFloat($('#sub_total_discount_amount').html()).toFixed(2);
		var total_discount_amount = parseFloat($('#all_items_discount').html()).toFixed(2);
		var delivery_charge = ($('#delivery_charge').val()!="")?parseFloat($('#delivery_charge').val()).toFixed(2):parseFloat(0).toFixed(2);
		var sub_total_discount_value = $('#sub_total_discount').val();
		var sub_total_discount_type = '';
		if(total_items_in_cart==0){
			swal({
                title: "Alert!",
                text: "Cart is empty!",
                confirmButtonColor: '#b6d6f6' 
            })	
			return false;
		}
		if(sub_total_discount_value.length>0 && sub_total_discount_value.substr(sub_total_discount_value.length - 1)=='%'){
			sub_total_discount_type = 'percentage';
		}else{
			sub_total_discount_type= 'plain'; 
		}
		var selected_table = 0;
		
		if($(".single_table_div[data-table-checked=checked]").length>0){
			selected_table = $(".single_table_div[data-table-checked=checked]").attr('id').substr(13);//1; //demo 	
		}
		
		var order_type = 0;
		if(selected_order_type_object.attr('id')=='delivery_button'){
			order_type = 3;
		}else if(selected_order_type_object.attr('id')=='dine_in_button'){
			order_type = 1;
		}else if(selected_order_type_object.attr('id')=='take_away_button'){
			order_type = 2;
		}

		var customer_id = $('#walk_in_customer').val();
		var waiter_id = $('#select_waiter').val();

		var order_status = 1;



		var order_info = '{';
		order_info += '"customer_id":"'+customer_id+'",';
		order_info += '"waiter_id":"'+waiter_id+'",';
		order_info += '"total_items_in_cart":"'+total_items_in_cart+'",';
		order_info += '"sub_total":"'+sub_total+'",';
		order_info += '"total_vat":"'+total_vat+'",';
		order_info += '"total_payable":"'+total_payable+'",';
		order_info += '"total_item_discount_amount":"'+total_item_discount_amount+'",';
		order_info += '"sub_total_with_discount":"'+sub_total_with_discount+'",';
		order_info += '"sub_total_discount_amount":"'+sub_total_discount_amount+'",';
		order_info += '"total_discount_amount":"'+total_discount_amount+'",';
		order_info += '"delivery_charge":"'+delivery_charge+'",';
		order_info += '"sub_total_discount_value":"'+sub_total_discount_value+'",';
		order_info += '"sub_total_discount_type":"'+sub_total_discount_type+'",';
		order_info += '"selected_table":"'+selected_table+'",';
		order_info += '"order_type":"'+order_type+'",';
		order_info += '"order_status":"'+order_status+'",';
		var items_info = '';
		items_info += '"items":';
		items_info += "[";

		if($('.order_holder .single_order').length>0){
			var k = 1;
			$('.order_holder .single_order').each(function(i, obj) {
				var item_id = $(this).attr('id').substr(15);
				var item_name = $(this).find('#item_name_table_'+item_id).html();
				var item_vat = $(this).find('.item_vat').html();
				var item_discount = $(this).find('#percentage_table_'+item_id).val();
				var discount_type = '';
				if(item_discount.length>0 && item_discount.substr(item_discount.length - 1)=='%'){
					discount_type = 'percentage';
				}else{
					discount_type= 'plain'; 
				}
				var item_price_without_discount = $(this).find('.item_price_without_discount').html();
				var item_unit_price = $(this).find('#item_price_table_'+item_id).html();
				var item_quantity = $(this).find('#item_quantity_table_'+item_id).html();
				var item_price_with_discount = $(this).find('#item_total_price_table_'+item_id).html();
				var item_discount_amount = (parseFloat(item_price_without_discount)-parseFloat(item_price_with_discount)).toFixed(2);
				items_info += '{"item_id":"'+item_id+'", "item_name":"'+item_name+'", "item_vat":"'+item_vat+'",';
				items_info += '"item_discount":"'+item_discount+'","discount_type":"'+discount_type+'","item_price_without_discount":"'+item_price_without_discount+'",';
				items_info += '"item_unit_price":"'+item_unit_price+'","item_quantity":"'+item_quantity+'",';
				items_info += '"item_price_with_discount":"'+item_price_with_discount+'","item_discount_amount":"'+item_discount_amount+'"';

				if($(this).find('.second_portion').length>0){
					var modifiers_id = $(this).find('#item_modifiers_id_table_'+item_id).html();
					var modifiers_price = $(this).find('#item_modifiers_price_table_'+item_id).html();
					items_info += ',"modifiers_id":"'+modifiers_id+'", "modifiers_price":"'+modifiers_price+'"';
				}else{
					items_info += ',"modifiers_id":"", "modifiers_price":""';
				}
				if($(this).find('.third_portion').length>0){
					var item_note = $(this).find('#item_note_table_'+item_id).html();
					items_info += ',"item_note":"'+item_note+'"';
				}else{
					items_info += ',"item_note":""';
				}
				items_info += (k==$('.order_holder .single_order').length)?'}':'},';
				k++;
			});	
		}
		items_info += "]";
		order_info += items_info+'}';

		var order_object = JSON.stringify(order_info); 



		add_hold_by_ajax(order_object,hold_number);
	});

}

$('.marquee').marquee({
    //speed in milliseconds of the marquee
    duration: 5000,
    //gap in pixels between the tickers
    gap: 250,
    //time in milliseconds before the marquee will start animating
    delayBeforeStart: 0,
    //'left' or 'right'
    direction: 'left',
    //true or false - should the marquee be duplicated to show an effect of continues flow
    duplicated: true
});

//this function adjust the left side order list height
function adjust_left_side_order_list(){
	var left_side_button_holder_height = $('#left_side_button_holder_absolute').height();
	var main_left_portion_height = $('.main_left').height();
	var header_of_left_portion_height = $('.main_left h3').height();
	var height_left_button_holder_and_header = (parseFloat(left_side_button_holder_height)+parseFloat(header_of_left_portion_height)).toFixed(2);
	var remaining_height_for_list = (parseFloat(main_left_portion_height)-parseFloat(height_left_button_holder_and_header)-parseFloat(35)).toFixed(2);
	$('.order_details').slimscroll({
		height: remaining_height_for_list+'px'
	}).parent().css({
		background: '#237FAD',
		border: '0px solid #184055'
	});
}
//this function adjust the left side order list height
function adjust_middle_side_cart_list(){
	var middle_side_bottom_holder_height = $('#bottom_absolute').height();
	var main_middle_portion_height = $('.main_middle').height();
	var order_table_header_row = $('.order_table_header_row').height();
	var header_of_middle_portion_height = $('.main_middle .main_top').height();
	var height_middle_bottom_holder_and_header = (parseFloat(middle_side_bottom_holder_height)+parseFloat(header_of_middle_portion_height)+parseFloat(order_table_header_row)).toFixed(2);
	var remaining_height_for_cart = (parseFloat(main_middle_portion_height)-parseFloat(height_middle_bottom_holder_and_header)).toFixed(2);
	$('.main_middle .order_holder').css('height',remaining_height_for_cart+'px');
	// $('.order_details').slimscroll({
	// 	height: remaining_height_for_list+'px'
	// }).parent().css({
	// 	background: '#237FAD',
	// 	border: '0px solid #184055'
	// });
}
//this function adjust the right side item list height
function adjust_right_side_item_list(){
	var main_right_portion_height = $('.main_right').height();
	var search_item_input_height = $('#search').height();
	var search_item_input_margin_bottom = parseFloat($('#search').css('margin-bottom'));
	var select_category_height = $('.select_category').height();
	var select_category_margin_bottom = parseFloat($('.select_category').css('margin-bottom'));
	var search_input_total_height = (parseFloat(search_item_input_height)+parseFloat(search_item_input_margin_bottom)).toFixed(2);
	var select_category_total_height = (parseFloat(select_category_height)+parseFloat(select_category_margin_bottom)).toFixed(2);
	var total_height_except_item_list = (parseFloat(search_input_total_height)+parseFloat(select_category_total_height)).toFixed(2);
	var remaining_height_for_item_list = (parseFloat(main_right_portion_height)-parseFloat(total_height_except_item_list)-parseFloat(13)).toFixed(2);
	$('#main_item_holder').css('height',remaining_height_for_item_list+'px');
	// ==========================================
	$('.category_items').slimscroll({
		height: remaining_height_for_item_list+'px'
	}).parent().css({
		border: '0px solid #184055'
	});	
}

$(window).on('resize', function(){
	var height_should_be = parseInt($(window).height())-parseInt($('.top_header_part').height())-20;
	$('.main_left').css('height',height_should_be+'px');
	$('.main_middle').css('height',height_should_be+'px');
	$('.main_right').css('height',height_should_be-10+'px');

	adjust_left_side_order_list();
	adjust_right_side_item_list();
	adjust_middle_side_cart_list();
});
function calculate_create_invoice_modal(){
	var total_payable = $('#finalize_total_payable').html();
	var paid_amount = ($('#pay_amount_invoice_input').val()!="")?$('#pay_amount_invoice_input').val():0;
	var due_amount = (parseFloat(total_payable)-parseFloat(paid_amount)).toFixed(2);
	$('#due_amount_invoice_input').val(due_amount);
}

// ===============================================
// add all prices of item and modifiers
function do_addition_of_item_and_modifiers_price(){
	//set all hidden discount amount and original item price
	set_all_hidden_item_discount_amount();

	//set visible discounted item price to table
	set_all_visible_discounted_item_price();

	//set total discount amount of items
	set_total_items_discount_for_subtotal();

	var total_of_all_items_and_modifiers = get_total_of_all_items_and_modifiers();
	//get total items in cart 
	var total_items_in_cart = $('.order_holder .single_order').length;
	//set row number for every single item
	$('.order_holder .single_order').each(function(i,obj){
		$(this).attr('data-single-order-row-no',i+1);
	});
	//if there is no item in cart reset necessary field and value
	if(total_items_in_cart<1){
		$('#discounted_sub_total_amount').html('0.00');
		$('#sub_total_discount').val('');
		$('#sub_total_discount_amount').html('0.00');
		$('#all_items_discount').html('0.00');
		$('#delivery_charge').val('');
	}
	var total_items_in_cart_with_quantity = 0;
	$('.order_holder .single_order .first_portion .third_column span').each(function(i, obj) {
		total_items_in_cart_with_quantity = parseInt(total_items_in_cart_with_quantity)+parseInt($(this).html());
	});

	//set total items in cart to view
	$('#total_items_in_cart').html(total_items_in_cart);
	$('#total_items_in_cart_with_quantity').html(total_items_in_cart_with_quantity);
	//set sub total
	$('#sub_total').html(total_of_all_items_and_modifiers);
	$('#sub_total_show').html(total_of_all_items_and_modifiers);

	//get the value of the delivery charge amount
	var delivery_charge_amount = ($('#delivery_charge').val()!="")?$('#delivery_charge').val():0;
	//check wether value is valid or not
	remove_last_two_digit_without_percentage(delivery_charge_amount,$('#delivery_charge'));

	//get subtotal amount
	var sub_total_amount = $('#sub_total').html();

	//get subtotal discount amount
	var sub_total_discount_amount = ($('#sub_total_discount').val()!="")?$('#sub_total_discount').val():0;
	
	//check wether value is valid or not
	remove_last_two_digit_with_percentage(sub_total_discount_amount,$('#sub_total_discount'));
	sub_total_discount_amount = get_sub_total_discount_amount(sub_total_discount_amount,sub_total_amount);	
	
	//if sub total discount amount is greater than subtotal then make it blank
	if(parseFloat(sub_total_discount_amount)>parseFloat(sub_total_amount)){
		$('#sub_total_discount').val('');
		do_addition_of_item_and_modifiers_price();
		return false;	
	}
	//get total item discount amount
	var total_item_discount_amount = (parseFloat($('#total_item_discount').html())).toFixed(2);

	//get all discount of table
	var total_discount = (parseFloat(sub_total_discount_amount)+parseFloat(total_item_discount_amount)).toFixed(2);
	
	//set sub total discount amount 
	$('#sub_total_discount_amount').html(sub_total_discount_amount);

	//set sub total amount after discount in a hidden field
	var discounted_sub_total_amount = (parseFloat(sub_total_amount)-parseFloat(sub_total_discount_amount)).toFixed(2);
	$('#discounted_sub_total_amount').html(discounted_sub_total_amount)

	//get vat amount
	var vat_amount = (collect_vat=="Yes")?get_total_vat():parseFloat(0).toFixed(2);

	//set vat amount to view
	$('#all_items_vat').html(vat_amount);

	//set total discount
	$('#all_items_discount').html(total_discount);


	//calculate total payable amount
	var total_payable = (parseFloat(discounted_sub_total_amount)+parseFloat(vat_amount)+parseFloat(delivery_charge_amount)).toFixed(2);

	//set total payable amount to view
	$('#total_payable').html(total_payable);	

}
function set_total_items_discount_for_subtotal(){
	var total_discount=0;
	$('.single_order .first_portion .fifth_column span').each(function(i, obj) {

		var this_item_discount_amount = (parseFloat($(this).parent().parent().find('.item_discount').html())).toFixed(2);
		total_discount = (parseFloat(total_discount)+parseFloat(this_item_discount_amount)).toFixed(2);
	});
	$('#total_item_discount').html(total_discount);
}
function set_all_hidden_item_discount_amount(){
	$('.single_order .first_portion .fifth_column span').each(function(i, obj) {
		var this_item_original_price = parseFloat($(this).parent().parent().find('.item_price_without_discount').html()).toFixed(2);
		var item_discount_value = $(this).parent().parent().find('.forth_column input').val();
		item_discount_value = (item_discount_value!="")?item_discount_value:0;
		var actual_discount_amount = get_particular_item_discount_amount(item_discount_value,this_item_original_price);
		$(this).parent().parent().find('.item_discount').html(actual_discount_amount);
	});
}
function set_all_visible_discounted_item_price(){
	$('.single_order .first_portion .fifth_column span').each(function(i, obj) {
		var this_item_original_price = parseFloat($(this).parent().parent().find('.item_price_without_discount').html()).toFixed(2);
		var item_discount_value = $(this).parent().parent().find('.forth_column input').val();
		item_discount_value = (item_discount_value!="")?item_discount_value:0;
		var actual_discount_amount = get_particular_item_discount_amount(item_discount_value,this_item_original_price);
		var discounted_item_price = (parseFloat(this_item_original_price)-parseFloat(actual_discount_amount)).toFixed(2);
		$(this).parent().parent().find('.fifth_column span').html(discounted_item_price);
	});	
}

function get_total_of_all_items_and_modifiers(){
	//get all items total price and add
	var all_item_total_price = 0;
	var all_item_total_vat_amount = 0;
	var this_item_discount = 0;
	$('.single_order .first_portion .fifth_column span').each(function(i, obj) {
		all_item_total_price = (parseFloat(all_item_total_price)+(parseFloat($(this).html()))).toFixed(2);
	});

	//get all modifiers price and add
	var all_modifiers_total_price = 0;
	$('.single_order .second_portion .fifth_column span').each(function(i, obj) {
		all_modifiers_total_price = (parseFloat(all_modifiers_total_price)+parseFloat($(this).html())).toFixed(2);
	});
	return (parseFloat(all_item_total_price)+parseFloat(all_modifiers_total_price)).toFixed(2);
}
function get_total_vat(){
	var all_item_total_vat_amount = 0;
	$('.single_order .first_portion .fifth_column span').each(function(i, obj) {
		var this_item_quantity = parseFloat($(this).parent().parent().find('.third_column span').html()).toFixed(2);
		var this_item_price = parseFloat($(this).parent().parent().find('.second_column span').html()).toFixed(2);
		var this_item_vat_percentage = parseFloat($(this).parent().parent().find('.item_vat').html()).toFixed(2);
		var this_item_vat_amount = ((parseFloat($(this).html())*parseFloat(this_item_vat_percentage))/parseFloat(100)).toFixed(2);
		all_item_total_vat_amount = (parseFloat(all_item_total_vat_amount)+parseFloat(this_item_vat_amount)).toFixed(2);
	});
	return all_item_total_vat_amount;
}
function get_all_item_discount(){
	var all_item_discount = 0;
	$('.single_order .first_portion .fifth_column span').each(function(i, obj) {
		var this_item_quantity = parseFloat($(this).parent().parent().find('.third_column span').html()).toFixed(2);
		var this_item_price = parseFloat($(this).parent().parent().find('.second_column span').html()).toFixed(2);
		var total_item_price_this_row = (parseFloat(this_item_quantity)*parseFloat(this_item_price)).toFixed(2);
		var this_item_discount = ($(this).parent().parent().find('.forth_column input').val()!="")?$(this).parent().parent().find('.forth_column input').val():0;
		this_item_discount = get_particular_item_discount_amount(this_item_discount,total_item_price_this_row);
		$(this).parent().parent().find('.item_discount').html(this_item_discount);
		// var this_item_discount = (parseFloat(this_item_discount)+parseFloat($(this).parent().parent().find('.item_discount').html())).toFixed(2);
		all_item_discount = (parseFloat(all_item_discount)+parseFloat(this_item_discount)).toFixed(2);
	});

	return all_item_discount;
}
function get_particular_item_discount_amount(discount,item_price){
	if(discount.length>0 && discount.substr(discount.length - 1)=='%'){
		return (((parseFloat(item_price)*parseFloat(discount))/parseFloat(100))).toFixed(2);
	}else{
		return parseFloat(discount).toFixed(2);
	}
}
function get_updated_sub_total(){
	//get all items total price and add
	var all_item_total_price = 0;
	var all_item_total_vat_amount = 0;
	var this_item_discount = 0;
	$('.single_order .first_portion .fifth_column span').each(function(i, obj) {
		var this_item_quantity = parseFloat($(this).parent().parent().find('.third_column span').html()).toFixed(2);
		var this_item_price = parseFloat($(this).parent().parent().find('.second_column span').html()).toFixed(2);
		var this_item_vat_percentage = parseFloat($(this).parent().parent().find('.item_vat').html()).toFixed(2);
		all_item_total_price = (parseFloat(all_item_total_price)+(parseFloat(this_item_quantity)*parseFloat(this_item_price))).toFixed(2);
		var this_item_vat_amount = ((parseFloat($(this).html())*parseFloat(this_item_vat_percentage))/parseFloat(100)).toFixed(2);
		all_item_total_vat_amount = (parseFloat(all_item_total_vat_amount)+parseFloat(this_item_vat_amount)).toFixed(2);
		
		var this_item_discount = (parseFloat(this_item_discount)+parseFloat($(this).parent().parent().find('.item_discount').html())).toFixed(2);
	});

	//get total discount 
	var total_discount = $('#all_items_discount');

	//get discount on sub total
	var sub_total_discount = ($('#sub_total_discount').val()=="")?$('#sub_total_discount').val():0;
	
	//get sub total 
	var sub_total = (parseFloat($('#sub_total').html())).toFixed(2);
	
	//get sub total discount amount
	var sub_total_discount_amount = get_sub_total_discount_amount($sub_total_discount,$sub_total);

	//get all modifiers price and add
	var all_modifiers_total_price = 0;
	$('.single_order .second_portion .fifth_column span').each(function(i, obj) {
		all_modifiers_total_price = (parseFloat(all_modifiers_total_price)+parseFloat($(this).html())).toFixed(2);
	});
	//set vat amount under sub total
	$('#all_items_vat').html(all_item_total_vat_amount);

	var total_of_all_items_and_modifiers = parseFloat(all_item_total_price)+parseFloat(all_modifiers_total_price);
	return total_of_all_items_and_modifiers;
}
function sub_total_get_amount($value){

}
function get_sub_total_discount_amount(sub_total_discount,sub_total){
	if(sub_total_discount.length>0 && sub_total_discount.substr(sub_total_discount.length - 1)=='%'){
		return (((parseFloat(sub_total)*parseFloat(sub_total_discount))/parseFloat(100))).toFixed(2);
	}else{
		return parseFloat(sub_total_discount).toFixed(2);
	}
}
function reset_on_modal_close_or_add_to_cart(){
	$('#item_modal').fadeOut('500');
	$('#item_quantity_modal').html('1');
	$('#modal_modifier_price_variable').html('0');
	$('#modal_item_note').val('');
	$('#modal_discount').val('');
	$('#modal_item_price_variable_without_discount').html('0')
	$('#modal_item_vat_percentage').html('0');
	$('#modal_item_row').html('0');
	$('#modal_discount_amount').html('0');
}
function reset_on_modal_close_or_add_customer(){
	$('#add_customer_modal').fadeOut('500');
	$('#customer_name_modal').val('');
	$('#customer_phone_modal').val('');
	$('#customer_email_modal').val('');
	$('#customer_dob_modal').val('');
	$('#customer_doa_modal').val('');
	$('#customer_delivery_address_modal').val('');
}

function upTime2(object,second,minute,hour) {
  table_id = object.attr('id').substr(13);
  if($('#booked_for_hour_'+table_id).html()=='00' && $('#booked_for_minute_'+table_id).html()=='00' && $('#booked_for_second_'+table_id).html()=='00'){
  	return false;
  }
  second++;
  if(second==60){
  	minute++;
  	second=0;
  }
  if(minute==60){
  	hour++;
  }
  hour = hour.toString();
  minute = minute.toString();
  second = second.toString();
  hour = (hour.length==1)?'0'+hour:hour;
  minute = (minute.length==1)?'0'+minute:minute;
  second = (second.length==1)?'0'+second:second;
  $('#booked_for_hour_'+table_id).html(hour);
  $('#booked_for_minute_'+table_id).html(minute);
  $('#booked_for_second_'+table_id).html(second);

  upTime2.to=setTimeout(function(){ upTime2(object,second,minute,hour); },1000);
}
function clearFooterCartCalculation(){
	$('#sub_total_show').html('0.00');
	$('#sub_total').html('0.00');
	$('#total_item_discount').html('0.00');
	$('#discounted_sub_total_amount').html('0.00');
	$('#sub_total_discount').val('');
	$('#sub_total_discount_amount').html('0.00');
	$('#all_items_vat').html('0.00');
	$('#all_items_discount').html('0.00');
	$('#delivery_charge').val('');
	$('#total_items_in_cart').html('0');
	$('#total_items_in_cart_with_quantity').html('0');
	$('#total_payable').html('0.00');
}		
function add_sale_by_ajax(order_object,sale_id){ 

	$.ajax({
		url:base_url+"Sale/add_sale_by_ajax",
		method:"POST",
		data:{
			order : order_object,
			sale_id : sale_id,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			if(response>0){
				set_new_orders_to_view();	
				swal({
					title: 'Alert',
					text: 'Order has been added to Running Orders and went to Kitchen Panel as well. Select any order from Running Orders to modify it or create invoice',
	                confirmButtonColor: '#b6d6f6' 
				});
			}

		},
		error:function(){
			alert("error");
		}
	});
}
function add_hold_by_ajax(order_object,hold_number) {
	$.ajax({
		url:base_url+"Sale/add_hold_by_ajax",
		method:"POST",
		data:{
			order : order_object,
			hold_number : hold_number,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			$('#generate_sale_hold_modal').hide();
			$('.order_holder').empty();
			clearFooterCartCalculation();
			$('#hold_generate_input').val('');

			$('.main_top').find('button').css('background-color','#F3F3F3');
			$('.main_top').find('button').attr('data-selected','unselected');
			$('#table_button').attr('disabled',false);
			$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
			reset_customer_waiter_to_default();

		},
		error:function(){
			alert("error");
		}
	});
}
function set_new_orders_to_view(){
	$.ajax({
		url:base_url+"Sale/get_new_orders_ajax",
		method:"GET",
		success:function(response) {
			response = JSON.parse(response);
			console.log(response);
			$order_list_left = '';
			var i = 1;
			for (var key in response) {
				var width = 100;
				var total_kitchen_type_items = response[key].total_kitchen_type_items;
				var total_kitchen_type_started_cooking_items = response[key].total_kitchen_type_started_cooking_items;
				var total_kitchen_type_done_items = response[key].total_kitchen_type_done_items;
				var splitted_width = (parseFloat(width)/parseFloat(total_kitchen_type_items)).toFixed(2);
				var percentage_for_started_cooking = (parseFloat(splitted_width)*parseFloat(total_kitchen_type_started_cooking_items)).toFixed(2);
				var percentage_for_done_cooking = (parseFloat(splitted_width)*parseFloat(total_kitchen_type_done_items)).toFixed(2);
				if(i==1){
					$order_list_left += '<div data-started-cooking="'+total_kitchen_type_started_cooking_items+'" data-done-cooking="'+total_kitchen_type_done_items+'" class="single_order fix" style="margin-top:0px" data-selected="unselected" id="order_'+response[key].sales_id+'">';	
				}else{
					$order_list_left += '<div data-started-cooking="'+total_kitchen_type_started_cooking_items+'" data-done-cooking="'+total_kitchen_type_done_items+'" class="single_order fix" data-selected="unselected" id="order_'+response[key].sales_id+'">';	
				}
				$order_list_left +='<div class="inside_single_order_container fix">';
			    // $order_list_left +='<div class="background_order_started" style="width:'+percentage_for_started_cooking+'%"></div>';
			    // $order_list_left +='<div class="background_order_done" style="width:'+percentage_for_done_cooking+'%"></div>';
			    $order_list_left +='<div class="single_order_content_holder_inside fix">';
				var order_name = '';
				if(response[key].order_type=='1'){
					order_name = 'A '+response[key].sale_no;
				}else if(response[key].order_type=='2'){
					order_name = 'B '+response[key].sale_no;
				}else if(response[key].order_type=='3'){
					order_name = 'C '+response[key].sale_no;
				} 

				//var table_name = (response[key].tables_booked[0].table_name!=null)?response[key].tables_booked[0].table_name:"";
				var table_name = "";
				var waiter_name = (response[key].waiter_name!=null)?response[key].waiter_name:"";
				var customer_name = (response[key].customer_name!=null)?response[key].customer_name:"";

				// var booked_time = new Date(Date.parse(response[key].date_time));
				// var now = new Date();
				
				// var  days = parseInt((now - booked_time) / (1000 * 60 * 60 * 24));
				// var  hours = parseInt(Math.abs(now - booked_time) / (1000 * 60 * 60) % 24);
				// var  minute = parseInt(Math.abs(now.getTime() - booked_time.getTime()) / (1000 * 60) % 60);
				// var  second = parseInt(Math.abs(now.getTime() - booked_time.getTime()) / (1000) % 60);
				// minute = minute.toString();
				// second = second.toString();
				// minute = (minute.length==1)?'0'+minute:minute;
				// second = (second.length==1)?'0'+second:second;

				minute = response[key].minute_difference;
				second = response[key].second_difference;

				var tables_booked = '';
			    if(response[key].tables_booked.length>0){
			        var w = 1;
			        for (var k in response[key].tables_booked) {
			        	var single_table = response[key].tables_booked[k];
			            if(w == response[key].tables_booked.length){
			                tables_booked += single_table.table_name;
			            }else{
			                tables_booked += single_table.table_name+', ';
			            }
			            w++;
			        }    
			    }else{
			        tables_booked = 'None';
			    }

				$order_list_left += '<span id="open_orders_order_status_'+response[key].sales_id+'" style="display:none;">'+response[key].order_status+'</span><p style="font-size: 16px;font-weight: bold;text-align:center;">Order: <span class="running_order_order_number">'+order_name+'</span></p>';
				$order_list_left += '<p>Table: <span class="running_order_table_name">'+tables_booked+'</span></p>';
				$order_list_left += '<p>Waiter: <span class="running_order_waiter_name">'+waiter_name+'</span></p>';
				$order_list_left += '<p>Customer: <span class="running_order_customer_name">'+customer_name+'</span></p>';
				$order_list_left += '</div>';
			    $order_list_left += '<div class="order_condition">';
			    $order_list_left += '<p class="order_on_processing">Started Cookiing: '+total_kitchen_type_items+'/'+total_kitchen_type_started_cooking_items+'</p>';
			    $order_list_left += '<p class="order_done">Done: '+total_kitchen_type_items+'/'+total_kitchen_type_done_items+'</p>';
			    $order_list_left += '</div>';
			    $order_list_left += '<div class="order_condition">';
			    $order_list_left += '<p style="font-size:16px;">Time Count: <span id="order_minute_count_'+response[key].sales_id+'">'+minute+'</span>:<span id="order_second_count_'+response[key].sales_id+'">'+second+'</span> M</p>';
			    $order_list_left += '</div>';
				$order_list_left += '</div>';
				$order_list_left += '</div>';
				i++;
			}
			$('#order_details_holder').html($order_list_left);
			$('.order_table_holder .order_holder').empty();
			clearFooterCartCalculation();
			$('.main_top').find('button').css('background-color','#F3F3F3');
			$('.main_top').find('button').attr('data-selected','unselected');
			$('#table_button').attr('disabled',false);
			$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
			reset_customer_waiter_to_default();
			reset_time_interval();
			all_time_interval_operation();

			reset_table_modal();

			// $("#walk_in_customer").select2().select2("val", "1");
		},
		error:function(){
			alert("error");
		}
	});
}
function set_new_orders_to_view_for_interval(){
	$.ajax({
		url:base_url+"Sale/get_new_orders_ajax",
		method:"GET",
		success:function(response) {
			response = JSON.parse(response);
			$order_list_left = '';
			var i = 1;
			for (var key in response) {
				var width = 100;
				var total_kitchen_type_items = response[key].total_kitchen_type_items;
				var total_kitchen_type_started_cooking_items = response[key].total_kitchen_type_started_cooking_items;
				var total_kitchen_type_done_items = response[key].total_kitchen_type_done_items;
				var splitted_width = (parseFloat(width)/parseFloat(total_kitchen_type_items)).toFixed(2);
				var percentage_for_started_cooking = (parseFloat(splitted_width)*parseFloat(total_kitchen_type_started_cooking_items)).toFixed(2);
				var percentage_for_done_cooking = (parseFloat(splitted_width)*parseFloat(total_kitchen_type_done_items)).toFixed(2);
				if(i==1){
					$order_list_left += '<div data-started-cooking="'+total_kitchen_type_started_cooking_items+'" data-done-cooking="'+total_kitchen_type_done_items+'" class="single_order fix" style="margin-top:0px" data-selected="unselected" id="order_'+response[key].sales_id+'">';	
				}else{
					$order_list_left += '<div data-started-cooking="'+total_kitchen_type_started_cooking_items+'" data-done-cooking="'+total_kitchen_type_done_items+'" class="single_order fix" data-selected="unselected" id="order_'+response[key].sales_id+'">';	
				}
				$order_list_left +='<div class="inside_single_order_container fix">';
			    // $order_list_left +='<div class="background_order_started" style="width:'+percentage_for_started_cooking+'%"></div>';
			    // $order_list_left +='<div class="background_order_done" style="width:'+percentage_for_done_cooking+'%"></div>';
			    $order_list_left +='<div class="single_order_content_holder_inside fix">';
				var order_name = '';
				if(response[key].order_type=='1'){
					order_name = 'A '+response[key].sale_no;
				}else if(response[key].order_type=='2'){
					order_name = 'B '+response[key].sale_no;
				}else if(response[key].order_type=='3'){
					order_name = 'C '+response[key].sale_no;
				}
				var table_name = (response[key].table_name!=null)?response[key].table_name:"";
				var waiter_name = (response[key].waiter_name!=null)?response[key].waiter_name:"";
				var customer_name = (response[key].customer_name!=null)?response[key].customer_name:"";

				// var booked_time = new Date(Date.parse(response[key].date_time));
				// var now = new Date();
				
				// var  days = parseInt((now - booked_time) / (1000 * 60 * 60 * 24));
				// var  hours = parseInt(Math.abs(now - booked_time) / (1000 * 60 * 60) % 24);
				// var  minute = parseInt(Math.abs(now.getTime() - booked_time.getTime()) / (1000 * 60) % 60);
				// var  second = parseInt(Math.abs(now.getTime() - booked_time.getTime()) / (1000) % 60);
				// minute = minute.toString();
				// second = second.toString();
				// minute = (minute.length==1)?'0'+minute:minute;
				// second = (second.length==1)?'0'+second:second;

				minute = response[key].minute_difference;
				second = response[key].second_difference;

				var tables_booked = '';
			    if(response[key].tables_booked.length>0){
			        var w = 1;
			        for (var k in response[key].tables_booked) {
			        	var single_table = response[key].tables_booked[k];
			            if(w == response[key].tables_booked.length){
			                tables_booked += single_table.table_name;
			            }else{
			                tables_booked += single_table.table_name+', ';
			            }
			            w++;
			        }    
			    }else{
			        tables_booked = 'None';
			    }

				$order_list_left += '<span id="open_orders_order_status_'+response[key].sales_id+'" style="display:none;">'+response[key].order_status+'</span><p style="font-size: 16px;font-weight: bold;text-align:center;">Order: <span class="running_order_order_number">'+order_name+'</span></p>';
				$order_list_left += '<p>Table: <span class="running_order_table_name">'+tables_booked+'</span></p>';
				$order_list_left += '<p>Waiter: <span class="running_order_waiter_name">'+waiter_name+'</span></p>';
				$order_list_left += '<p>Customer: <span class="running_order_customer_name">'+customer_name+'</span></p>';
				$order_list_left += '</div>';
			    $order_list_left += '<div class="order_condition">';
			    $order_list_left += '<p class="order_on_processing">Started Cooking: '+total_kitchen_type_started_cooking_items+'/'+total_kitchen_type_items+'</p>';
			    $order_list_left += '<p class="order_done">Done: '+total_kitchen_type_done_items+'/'+total_kitchen_type_items+'</p>';
			    $order_list_left += '</div>';
			    $order_list_left += '<div class="order_condition">';
			    $order_list_left += '<p style="font-size:16px;">Time Count: <span id="order_minute_count_'+response[key].sales_id+'">'+minute+'</span>:<span id="order_second_count_'+response[key].sales_id+'">'+second+'</span> M</p>';
			    $order_list_left += '</div>';
				$order_list_left += '</div>';
				$order_list_left += '</div>';
				i++;
			}
			$('#order_details_holder').html($order_list_left);
			
		},
		error:function(){
			console.log('Left Order Refresh Ajax Error');
		}
	});
}
function reset_customer_waiter_to_default(){
	var cid = $('#walk_in_customer > option:contains("Walk-in Customer")').attr('value');
	var wid = $('#select_waiter > option:contains("Default Waiter")').attr('value');
	$("#walk_in_customer").val(cid).trigger("change");
	$("#select_waiter").val(wid).trigger('change');
}
function print_kot(sale_id){
	let newWindow = open("print_kot/"+sale_id, 'Print KOT', 'width=450,height=550')
	newWindow.focus();

	newWindow.onload = function() {
	  newWindow.document.body.insertAdjacentHTML('afterbegin');
	};
}
function print_invoice_and_close(sale_id,payment_method_type,invoice_create_type,paid_amount,due_amount){
	
	if(invoice_create_type == 1){ //if type is 1 then update order status to invoiced order, and update payment method type
		update_order_status_to_invoiced(sale_id,payment_method_type,paid_amount,due_amount);
	}else if(invoice_create_type == 2){ //then change order status to close, close time update, payment method type update, 
		close_order(sale_id,payment_method_type,paid_amount,due_amount);
	}
	print_invoice(sale_id);
}
function get_all_hold_sales() {
	$.ajax({
		url:base_url+"Sale/get_all_holds_ajax",
		method:"GET",
		success:function(response) {
			var orders = JSON.parse(response);
			var held_orders = '';
			for (var key in orders) {
				var customer_name = (orders[key].customer_name==null || orders[key].customer_name=="")?"&nbsp;":orders[key].customer_name;
				var table_name = (orders[key].table_name!=null)?orders[key].table_name:"&nbsp;";
				held_orders += '<div class="single_hold_sale fix" id="hold_'+orders[key].id+'" data-selected="unselected">';
					held_orders += '<div class="first_column column fix">'+orders[key].hold_no+'</div>';
                    held_orders += '<div class="second_column column fix">'+customer_name+'</div>';
                    held_orders += '<div class="third_column column fix">'+table_name+'</div>';  
                held_orders += '</div>';
			}
			$(".hold_list_holder .detail_holder ").empty();
			$(".hold_list_holder .detail_holder ").prepend(held_orders);
		},
		error:function(){
			alert("error");
		}
	});
}
function update_order_status_to_invoiced(sale_id,payment_method_type,paid_amount,due_amount){
	$.ajax({
		url:base_url+"Sale/update_order_status_ajax",
		method:"POST",
		data:{
			sale_id : sale_id,
			close_order : false,
			paid_amount : paid_amount,
			due_amount : due_amount,
			payment_method_type : payment_method_type,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			if(response>1){
				set_new_orders_to_view();
			}
		},
		error:function(){
			alert("error");
		}
	});
}
function close_order(sale_id,payment_method_type,paid_amount, due_amount){
	$.ajax({
		url:base_url+"Sale/update_order_status_ajax",
		method:"POST",
		data:{
			sale_id : sale_id,
			close_order : true,
			paid_amount : paid_amount,
			due_amount : due_amount,
			payment_method_type : payment_method_type,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			if(response>1){
				set_new_orders_to_view();
			}
		},
		error:function(){
			alert("error");
		}
	});
}
function print_invoice(sale_id){
	
	let newWindow = open("print_invoice/"+sale_id, 'Print Invoice', 'width=450,height=550')
	newWindow.focus();

	newWindow.onload = function() {
	  newWindow.document.body.insertAdjacentHTML('afterbegin');
	};
}
function get_details_of_a_particular_hold(hold_id){
	$.ajax({
		url:base_url+"Sale/get_single_hold_info_by_ajax",
		method:"POST",
		data:{
			hold_id : hold_id,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			response = JSON.parse(response);
			hold_id = response.id;
			var draw_table_for_order='';

			for (var key in response.items) {

				//construct div
				var this_item = response.items[key];

				var selected_modifiers = '';
				var selected_modifiers_id = '';
				var selected_modifiers_price = '';
				var modifiers_price = 0;
				var total_modifier = this_item.modifiers.length;
				var i = 1;
				for(var mod_key in this_item.modifiers)
				{
					var this_modifier = this_item.modifiers[mod_key];
					//get selected modifiers
					if(i == total_modifier){
						selected_modifiers += this_modifier.name;
						selected_modifiers_id += this_modifier.modifier_id;
						selected_modifiers_price += this_modifier.modifier_price;
						modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
					}else{
						selected_modifiers += this_modifier.name+',';
						selected_modifiers_id += this_modifier.modifier_id+',';
						selected_modifiers_price += this_modifier.modifier_price+',';
						modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
					}
					i++;
				}

				draw_table_for_order += '<div class="single_order fix" id="order_for_item_'+this_item.food_menu_id+'">';
				draw_table_for_order += '<div class="first_portion fix">';
				draw_table_for_order += '<span class="item_vat" id="item_vat_percentage_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_vat_percentage+'</span>';
				draw_table_for_order += '<span class="item_discount" id="item_discount_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.discount_amount+'</span>';
				draw_table_for_order += '<span class="item_price_without_discount" id="item_price_without_discount_'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_price_without_discount+'</span>';
				draw_table_for_order += '<div class="single_order_column first_column fix"><i style="cursor:pointer;" class="fas fa-pencil-alt edit_item" id="edit_item_'+this_item.food_menu_id+'"></i> <span id="item_name_table_'+this_item.food_menu_id+'">'+this_item.menu_name+'</span></div>';
				draw_table_for_order += '<div class="single_order_column second_column fix">'+currency+' <span id="item_price_table_'+this_item.food_menu_id+'">'+this_item.menu_unit_price+'</span></div>';
				draw_table_for_order += '<div class="single_order_column third_column fix"><i style="cursor:pointer;" class="fas fa-minus-circle decrease_item_table" id="decrease_item_table_'+this_item.food_menu_id+'"></i> <span id="item_quantity_table_'+this_item.food_menu_id+'">'+this_item.qty+'</span> <i style="cursor:pointer;" class="fas fa-plus-circle increase_item_table" id="increase_item_table_'+this_item.food_menu_id+'"></i></div>';
				draw_table_for_order += '<div class="single_order_column forth_column fix"><input type="" name="" placeholder="Amt or %" class="special_textbox" id="percentage_table_'+this_item.food_menu_id+'" value="'+this_item.menu_discount_value+'" disabled></div>';
				draw_table_for_order += '<div class="single_order_column fifth_column fix">'+currency+' <span id="item_total_price_table_'+this_item.food_menu_id+'">'+this_item.menu_price_with_discount+'</span></div>';
				draw_table_for_order += '</div>';
				if(selected_modifiers!=""){
					draw_table_for_order += '<div class="second_portion fix">';
					draw_table_for_order += '<span id="item_modifiers_id_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_id+'</span>';
					draw_table_for_order += '<span id="item_modifiers_price_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_price+'</span>';
					draw_table_for_order += '<div class="single_order_column first_column fix"><span id="item_modifiers_table_'+this_item.food_menu_id+'">'+selected_modifiers+'</span></div>';
					draw_table_for_order += '<div class="single_order_column fifth_column fix">'+currency+' <span id="item_modifiers_price_table_'+this_item.food_menu_id+'">'+modifiers_price+'</span></div>';
					draw_table_for_order += '</div>';
				}
				if(this_item.menu_note!=""){
					draw_table_for_order += '<div class="third_portion fix">';
					draw_table_for_order += '<div class="single_order_column first_column fix">Note: <span id="item_note_table_'+this_item.food_menu_id+'">'+this_item.menu_note+'</span></div>';
					draw_table_for_order += '</div>';	
				}

				draw_table_for_order += '</div>';


			}
			//add to top
			$(".order_holder").prepend(draw_table_for_order);
			$("#total_items_in_cart").html(response.total_items);
			$("#sub_total_show").html(response.sub_total);
			$("#sub_total").html(response.sub_total);
			$("#total_item_discount").html(response.total_item_discount_amount);
			$("#discounted_sub_total_amount").html(response.sub_total_discount_amount);
			$("#sub_total_discount").val(response.sub_total_discount_value);
			$("#sub_total_discount_amount").html(response.sub_total_with_discount);
			$("#all_items_vat").html(response.vat);	
			$("#all_items_discount").html(response.total_discount_amount);
			$("#delivery_charge").val(response.delivery_charge);
			$("#total_payable").html(response.total_payable);
			//do calculation on table
			do_addition_of_item_and_modifiers_price();

			$('#hold_waiter_id').html('');
			$('#hold_waiter_name').html('');
			$('#hold_customer_id').html('');
			$('#hold_customer_name').html('');
			$('#hold_table_id').html('');
			$('#hold_table_name').html('');
			$('#hold_order_type').html('');
			$('#hold_order_type_id').html('');
			$(".item_modifier_details .modifier_item_details_holder").empty();
			$("#total_items_in_cart_hold").html('0');
			$("#sub_total_show_hold").html('0.00');
			$("#sub_total_hold").html('0.00');
			$("#total_item_discount_hold").html('0.00');
			$("#discounted_sub_total_amount_hold").html('0.00');
			$("#sub_total_discount_hold").html('');
			$("#sub_total_discount_amount_hold").html('0.00');
			$("#all_items_vat_hold").html('0.00');	
			$("#all_items_discount_hold").html('0.00');
			$("#delivery_charge_hold").html('0.00');
			$("#total_payable_hold").html('0.00');
			$('#show_sale_hold_modal').hide();

			if(response.customer_id=="" || response.customer_id==0 || response.customer_id==null){
				$("#walk_in_customer").val(1).trigger("change");	
			}else{
				$("#walk_in_customer").val(response.customer_id).trigger("change");
			}

			if(response.waiter_id=="" || response.waiter_id==0 || response.waiter_id==null){
				$("#select_waiter").val('').trigger("change");	
			}else{
				$("#select_waiter").val(response.waiter_id).trigger("change");
			}
			if(response.order_type=='1'){
				$('.main_top').find('button').css('background-color','#F3F3F3');
				$('.main_top').find('button').attr('data-selected','unselected');

				$('#dine_in_button').css('background-color','#B5D6F6'); 
				$('#dine_in_button').attr('data-selected','selected');

				$('#table_button').attr('disabled',false);

			}else if(response.order_type=='2'){
				$('.main_top').find('button').css('background-color','#F3F3F3');
				$('.main_top').find('button').attr('data-selected','unselected');

				$('#take_away_button').css('background-color','#B5D6F6'); 
				$('#take_away_button').attr('data-selected','selected');

				$('#table_button').attr('disabled',false);
				
			}else if(response.order_type=='3'){
				$('.main_top').find('button').css('background-color','#F3F3F3');
				$('.main_top').find('button').attr('data-selected','unselected');

				$('#delivery_button').css('background-color','#B5D6F6'); 
				$('#delivery_button').attr('data-selected','selected');

				$('#table_button').attr('disabled',true);
				$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
				$('.single_table_div[data-table-checked=checked]').css('background-color','#ffffff');
			}else{
				$('.main_top').find('button').css('background-color','#F3F3F3');
				$('.main_top').find('button').attr('data-selected','unselected');
			}
			if(response.table_id>0){
				$('.single_table_div').attr('data-table-checked','unchecked');
				$('.single_table_div').css('background-color','#ffffff');
				if($('#single_table_'+response.table_id).attr('data-table-checked')!='busy'){
					$('#single_table_'+response.table_id).attr('data-table-checked','checked');
					$('#single_table_'+response.table_id).css('background-color','#b6d6f6');	
				}
			}
		},
		error:function(){
			alert("error");
		}
	});
}
function get_details_of_a_particular_order_for_kot_modal(sale_id) {
	$.ajax({
		url:base_url+"Sale/get_all_information_of_a_sale_ajax",
		method:"POST",
		data:{
			sale_id : sale_id,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			response = JSON.parse(response);
			var order_type = '';
			var order_type_id = 0;
			var order_number = '';
			var tables_booked = '';
		    if(response.tables_booked.length>0){
		        var w = 1;
		        for (var k in response.tables_booked) {
		        	var single_table = response.tables_booked[k];
		            if(w == response.tables_booked.length){
		                tables_booked += single_table.table_name;
		            }else{
		                tables_booked += single_table.table_name+', ';
		            }
		            w++;
		        }    
		    }else{
		        tables_booked = 'None';
		    }
			$('#kot_modal_customer_id').html(response.customer_id);
			$('#kot_modal_customer_name').html(response.customer_name);
			$('#kot_modal_waiter_name').html(response.waiter_name);
			$('#kot_modal_order_date').html(response.date_time);
			
			$('#kot_modal_table_name').html(tables_booked);
			
			if(response.modified=='Yes'){
				$('#kot_modal_modified_or_not').show();
			}


			if(response.order_type==1){
				order_type = 'Dine In';
				order_type_id = 1;
				order_number = 'A '+response.sale_no;
			}else if(response.order_type==2){
				order_type = 'Take Away';
				order_type_id = 2;
				order_number = 'B '+response.sale_no;
				$('#kot_modal_waiter_name').html('None');
			}else if(response.order_type==3){
				order_type = 'Delivery';
				order_type_id = 3;
				order_number = 'C '+response.sale_no;
				$('#kot_modal_waiter_name').html('None');
			}
			$('#kot_modal_order_number').html(order_number);
			$('#kot_modal_order_type').html(order_type);
			var draw_table_for_kot_modal='';
			
			for (var key in response.items) {

				//construct div
				var this_item = response.items[key];
				
				var selected_modifiers = '';
				var selected_modifiers_id = '';
				var selected_modifiers_price = '';
				var modifiers_price = 0;
				var total_modifier = this_item.modifiers.length;
				var i = 1;
				for(var mod_key in this_item.modifiers)
				{
					var this_modifier = this_item.modifiers[mod_key];
					//get selected modifiers
			    	if(i == total_modifier){
		    			selected_modifiers += this_modifier.name;
		    			selected_modifiers_id += this_modifier.modifier_id;
		    			selected_modifiers_price += this_modifier.modifier_price;
			    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
			    	}else{
		    			selected_modifiers += this_modifier.name+',';
		    			selected_modifiers_id += this_modifier.modifier_id+',';
			    		selected_modifiers_price += this_modifier.modifier_price+',';
			    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
			    	}
				    i++;
				}
				var selected_modifiers_array = selected_modifiers.split(",");
				var selected_modifiers_id_array = selected_modifiers_id.split(",");
				var selected_modifiers_price_array = selected_modifiers_price.split(",");
				var modifier_divs = '';
				var modifier_length = selected_modifiers_array.length;
				if(modifier_length>0){
					for (var index = 0; index < modifier_length; index++) {
					    modifier_divs += (selected_modifiers_array[index]!="")?'<div data-selected="unselected" data-modifier-id="'+selected_modifiers_id_array[index]+'" data-item-detail-id="'+this_item.id+'" class="single_modifier floatleft fix">'+selected_modifiers_array[index]+'</div>':'';
					}	
				}
				
				var discount_value = (this_item.menu_discount_value!="")?this_item.menu_discount_value:'0.00';
				draw_table_for_kot_modal += '<div class="single_kot_row fix" id="kot_for_item_'+this_item.id+'">';
					draw_table_for_kot_modal += '<div class="kot_content_column fix floatleft kot_check_column">';
						draw_table_for_kot_modal += '<input checked class="kot_item_checkbox" id="kot_item_checkbox_'+this_item.id+'" type="checkbox" name="" value="'+this_item.id+'">';
					draw_table_for_kot_modal += '</div>';
					draw_table_for_kot_modal += '<div class="kot_content_column fix floatleft kot_item_name_column">';
						draw_table_for_kot_modal += this_item.menu_name;
					draw_table_for_kot_modal += '</div>';
					draw_table_for_kot_modal += '<div class="kot_content_column fix floatleft kot_qty_column">';
						draw_table_for_kot_modal += '<i style="cursor:pointer;" id="decrease_item_kot_modal_'+this_item.id+'" class="fas fa-minus-circle decrease_item_kot_modal"></i>';
						draw_table_for_kot_modal += ' <span style="display:none" id="kot_modal_item_qty_fixed_'+this_item.id+'">'+this_item.qty+'</span><span id="kot_modal_item_qty_'+this_item.id+'">'+this_item.qty+'</span> ';
						draw_table_for_kot_modal += '<i style="cursor:pointer;" id="increase_item_kot_modal_'+this_item.id+'" class="fas fa-plus-circle increase_item_kot_modal"></i>';
					draw_table_for_kot_modal += '</div>';
					draw_table_for_kot_modal += '<div class="kot_content_column fix floatleft kot_modifier_column">';
						// draw_table_for_kot_modal += selected_modifiers;
						draw_table_for_kot_modal += modifier_divs;
					draw_table_for_kot_modal += '</div>';
				draw_table_for_kot_modal += '</div>';
                            
                            
                            
                        



				// draw_table_for_order_details += '<div class="single_item_modifier fix" id="order_details_for_item_'+this_item.food_menu_id+'">';
				// 	draw_table_for_order_details += '<div class="first_portion fix">';
				// 		draw_table_for_order_details += '<span class="item_vat_hold" id="order_details_item_vat_percentage_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_vat_percentage+'</span>';
				// 		draw_table_for_order_details += '<span class="item_discount_hold" id="order_details_item_discount_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.discount_amount+'</span>';
				// 		draw_table_for_order_details += '<span class="item_price_without_discount_hold" id="order_details_item_price_without_discount_'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_price_without_discount+'</span>';
				// 		draw_table_for_order_details += '<div class="single_order_column_hold first_column column fix"><span id="order_details_item_name_table_'+this_item.food_menu_id+'">'+this_item.menu_name+'</span></div>';
				// 		draw_table_for_order_details += '<div class="single_order_column_hold second_column column fix">'+currency+' <span id="order_details_item_price_table_'+this_item.food_menu_id+'">'+this_item.menu_unit_price+'</span></div>';
				// 		draw_table_for_order_details += '<div class="single_order_column_hold third_column column fix"><span id="order_details_item_quantity_table_'+this_item.food_menu_id+'">'+this_item.qty+'</span></div>';
				// 		draw_table_for_order_details += '<div class="single_order_column_hold forth_column column fix"><span class="order_details_special_textbox" id="order_details_percentage_table_'+this_item.food_menu_id+'">'+discount_value+'</span></div>';
				// 		draw_table_for_order_details += '<div class="single_order_column_hold fifth_column column fix">'+currency+' <span id="order_details_item_total_price_table_'+this_item.food_menu_id+'">'+this_item.menu_price_with_discount+'</span></div>';
				// 	draw_table_for_order_details += '</div>';
				// 	if(selected_modifiers!=""){
				// 		draw_table_for_order_details += '<div class="second_portion fix">';
				// 			draw_table_for_order_details += '<span id="order_details_item_modifiers_id_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_id+'</span>';
				// 			draw_table_for_order_details += '<span id="order_details_item_modifiers_price_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_price+'</span>';
				// 			draw_table_for_order_details += '<div class="single_order_column_hold first_column column fix"><span id="order_details_item_modifiers_table_'+this_item.food_menu_id+'">'+selected_modifiers+'</span></div>';
				// 			draw_table_for_order_details += '<div class="single_order_column_hold second_column column fix">'+currency+' <span id="order_details_item_modifiers_price_table_'+this_item.food_menu_id+'">'+modifiers_price+'</span></div>';
				// 		draw_table_for_order_details += '</div>';
				// 	}
				// 	if(this_item.menu_note!=""){
				// 		draw_table_for_order_details += '<div class="third_portion fix">';
				// 			draw_table_for_order_details += '<div class="single_order_column_hold first_column column fix">Note: <span id="order_details_item_note_table_'+this_item.food_menu_id+'">'+this_item.menu_note+'</span></div>';
				// 		draw_table_for_order_details += '</div>';	
				// 	}
					
				// draw_table_for_order_details += '</div>';


			}
			

			//add to top
			$("#kot_list_holder").empty();
			$("#kot_list_holder").prepend(draw_table_for_kot_modal);
			
			// $("#order_detail_modal").show();
			// $(".order_holder_hold").prepend('<span id="modification_'+sale_id+'" class="modification" style="display:none;">'+sale_id+'</span>');
			//do calculation on table
		},
		error:function(){
			alert("error");
		}
	});	
}
function get_details_of_a_particular_order_for_modal(sale_id){
	$.ajax({
		url:base_url+"Sale/get_all_information_of_a_sale_ajax",
		method:"POST",
		data:{
			sale_id : sale_id,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			response = JSON.parse(response);
			var order_type = '';
			var order_type_id = 0;
			var order_number = '';
			var tables_booked = '';
		    if(response.tables_booked.length>0){
		        var w = 1;
		        for (var k in response.tables_booked) {
		        	var single_table = response.tables_booked[k];
		            if(w == response.tables_booked.length){
		                tables_booked += single_table.table_name;
		            }else{
		                tables_booked += single_table.table_name+', ';
		            }
		            w++;
		        }    
		    }else{
		        tables_booked = 'None';
		    }
			$('#order_details_waiter_id').html(response.waiter_id);
			$('#order_details_waiter_name').html(response.waiter_name);
			$('#order_details_customer_id').html(response.customer_id);
			$('#order_details_customer_name').html(response.customer_name);
			$('#order_details_table_id').html(response.table_id);
			$('#order_details_table_name').html(tables_booked);
			if(response.order_type==1){
				order_type = 'Dine In';
				order_type_id = 1;
				order_number = 'A '+response.sale_no;
			}else if(response.order_type==2){
				order_type = 'Take Away';
				order_type_id = 2;
				order_number = 'B '+response.sale_no;
			}else if(response.order_type==3){
				order_type = 'Delivery';
				order_type_id = 3;
				order_number = 'C '+response.sale_no;
			}
			$('#order_details_type').html(order_type);
			$('#order_details_type_id').html(order_type_id);
			$('#order_details_order_number').html(order_number);
			var draw_table_for_order_details='';
			
			for (var key in response.items) {

				//construct div
				var this_item = response.items[key];
				
				var selected_modifiers = '';
				var selected_modifiers_id = '';
				var selected_modifiers_price = '';
				var modifiers_price = 0;
				var total_modifier = this_item.modifiers.length;
				var i = 1;
				for(var mod_key in this_item.modifiers)
				{
					var this_modifier = this_item.modifiers[mod_key];
					//get selected modifiers
			    	if(i == total_modifier){
		    			selected_modifiers += this_modifier.name;
		    			selected_modifiers_id += this_modifier.modifier_id;
		    			selected_modifiers_price += this_modifier.modifier_price;
			    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
			    	}else{
		    			selected_modifiers += this_modifier.name+',';
		    			selected_modifiers_id += this_modifier.modifier_id+',';
			    		selected_modifiers_price += this_modifier.modifier_price+',';
			    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
			    	}
				    i++;
				}
				var discount_value = (this_item.menu_discount_value!="")?this_item.menu_discount_value:'0.00';
				draw_table_for_order_details += '<div class="single_item_modifier fix" id="order_details_for_item_'+this_item.food_menu_id+'">';
					draw_table_for_order_details += '<div class="first_portion fix">';
						draw_table_for_order_details += '<span class="item_vat_hold" id="order_details_item_vat_percentage_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_vat_percentage+'</span>';
						draw_table_for_order_details += '<span class="item_discount_hold" id="order_details_item_discount_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.discount_amount+'</span>';
						draw_table_for_order_details += '<span class="item_price_without_discount_hold" id="order_details_item_price_without_discount_'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_price_without_discount+'</span>';
						draw_table_for_order_details += '<div class="single_order_column_hold first_column column fix"><span id="order_details_item_name_table_'+this_item.food_menu_id+'">'+this_item.menu_name+'</span></div>';
						draw_table_for_order_details += '<div class="single_order_column_hold second_column column fix">'+currency+' <span id="order_details_item_price_table_'+this_item.food_menu_id+'">'+this_item.menu_unit_price+'</span></div>';
						draw_table_for_order_details += '<div class="single_order_column_hold third_column column fix"><span id="order_details_item_quantity_table_'+this_item.food_menu_id+'">'+this_item.qty+'</span></div>';
						draw_table_for_order_details += '<div class="single_order_column_hold forth_column column fix"><span class="order_details_special_textbox" id="order_details_percentage_table_'+this_item.food_menu_id+'">'+discount_value+'</span></div>';
						draw_table_for_order_details += '<div class="single_order_column_hold fifth_column column fix">'+currency+' <span id="order_details_item_total_price_table_'+this_item.food_menu_id+'">'+this_item.menu_price_with_discount+'</span></div>';
					draw_table_for_order_details += '</div>';
					if(selected_modifiers!=""){
						draw_table_for_order_details += '<div class="second_portion fix">';
							draw_table_for_order_details += '<span id="order_details_item_modifiers_id_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_id+'</span>';
							draw_table_for_order_details += '<span id="order_details_item_modifiers_price_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_price+'</span>';
							draw_table_for_order_details += '<div class="single_order_column_hold first_column column fix"><span id="order_details_item_modifiers_table_'+this_item.food_menu_id+'">'+selected_modifiers+'</span></div>';
							draw_table_for_order_details += '<div class="single_order_column_hold second_column column fix">'+currency+' <span id="order_details_item_modifiers_price_table_'+this_item.food_menu_id+'">'+modifiers_price+'</span></div>';
						draw_table_for_order_details += '</div>';
					}
					if(this_item.menu_note!=""){
						draw_table_for_order_details += '<div class="third_portion fix">';
							draw_table_for_order_details += '<div class="single_order_column_hold first_column column fix">Note: <span id="order_details_item_note_table_'+this_item.food_menu_id+'">'+this_item.menu_note+'</span></div>';
						draw_table_for_order_details += '</div>';	
					}
					
				draw_table_for_order_details += '</div>';


			}
			

			//add to top
			$(".order_detail_modal_info_holder .top .top_middle .item_modifier_details .modifier_item_details_holder").empty();
			$(".order_detail_modal_info_holder .top .top_middle .item_modifier_details .modifier_item_details_holder").prepend(draw_table_for_order_details);
			var total_items_in_cart_with_quantity = 0;
			$('.modifier_item_details_holder .single_item_modifier .first_portion .third_column span').each(function(i, obj) {
				total_items_in_cart_with_quantity = parseInt(total_items_in_cart_with_quantity)+parseInt($(this).html());
			});
			var sub_total_discount_order_details = (response.sub_total_discount_value!="")?response.sub_total_discount_value:"0.00";
			//set total items in cart to view
			$('#total_items_in_cart_order_details').html(total_items_in_cart_with_quantity);
			$("#sub_total_show_order_details").html(response.sub_total);
			$("#sub_total_order_details").html(response.sub_total);
			$("#total_item_discount_order_details").html(response.total_item_discount_amount);
			$("#discounted_sub_total_amount_order_details").html(response.sub_total_discount_amount);
			$("#sub_total_discount_order_details").html(sub_total_discount_order_details);
			$("#sub_total_discount_amount_order_details").html(response.sub_total_with_discount);
			$("#all_items_vat_order_details").html(response.vat);	
			$("#all_items_discount_order_details").html(response.total_discount_amount);
			$("#delivery_charge_order_details").html(response.delivery_charge);
			$("#total_payable_order_details").html(response.total_payable);
			$("#order_detail_modal").show();
			// $(".order_holder_hold").prepend('<span id="modification_'+sale_id+'" class="modification" style="display:none;">'+sale_id+'</span>');
			//do calculation on table
		},
		error:function(){
			alert("error");
		}
	});
}

function get_details_of_a_particular_order(sale_id){
	$.ajax({
		url:base_url+"Sale/get_all_information_of_a_sale_ajax",
		method:"POST",
		data:{
			sale_id : sale_id,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			response = JSON.parse(response);
			arrange_info_on_the_cart_to_modify(response);
			
		},
		error:function(){
			alert("error");
		}
	});
}
//remove last digits if number is more than 2 digits after decimal
function remove_last_two_digit_with_percentage(value,object_element){
	if(value.length>0 && value.indexOf('.')>0)
	{	
		var percentage = false;
		var number_without_percentage = value;
		if(value.indexOf('%')>0){
			percentage = true;
			number_without_percentage = value.toString().substring(0, value.length - 1);
		}
		var number = number_without_percentage.split('.');
		if (number[1].length > 2)
	    {
	        var value = parseFloat(Math.floor(number_without_percentage* 100) / 100);
	        add_percentage = (percentage)?'%':'';
	        if(isNaN(value)){
	        	object_element.val('');
	        }else{
	        	object_element.val(value.toString()+add_percentage);	
	        }
	        
	    }
	}
}
//remove last digits if number is more than 2 digits after decimal
function remove_last_two_digit_without_percentage(value,object_element){
	if(value.length>0 && value.indexOf('.')>0)
	{	
		var percentage = false;
		var number_without_percentage = value;
		if(value.indexOf('%')>0){
			percentage = true;
			number_without_percentage = value.toString().substring(0, value.length - 1);
		}
		var number = number_without_percentage.split('.');
		if (number[1].length > 2)
	    {
	        var value = parseFloat(Math.floor(number_without_percentage* 100) / 100);
	        add_percentage = (percentage)?'%':'';
	        if(isNaN(value)){
	        	object_element.val('');
	        }else{
	        	object_element.val(value.toString()+add_percentage);	
	        }
	        
	    }
	}
}
function check_address_of_customer(customer_id){
	$.ajax({
		url:base_url+"Sale/check_customer_address_ajax",
		method:"POST",
		data:{
			customer_id : customer_id,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			response = JSON.parse(response);
			if(response.address=="" || response.address==null)
				return false;
		},
		error:function(){
			alert("error");
		}
	});	
}
function cancel_order(sale_id){
	$.ajax({
		url:base_url+"Sale/cancel_particular_order_ajax",
		method:"POST",
		data:{
			sale_id : sale_id,
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			$.ajax({
				url:base_url+"Sale/get_new_orders_ajax",
				method:"GET",
				success:function(response) {
					response = JSON.parse(response);
					$order_list_left = '';
					var i = 1;
					for (var key in response) {
						var width = 100;
						var total_kitchen_type_items = response[key].total_kitchen_type_items;
						var total_kitchen_type_started_cooking_items = response[key].total_kitchen_type_started_cooking_items;
						var total_kitchen_type_done_items = response[key].total_kitchen_type_done_items;
						var splitted_width = (parseFloat(width)/parseFloat(total_kitchen_type_items)).toFixed(2);
						var percentage_for_started_cooking = (parseFloat(splitted_width)*parseFloat(total_kitchen_type_started_cooking_items)).toFixed(2);
						var percentage_for_done_cooking = (parseFloat(splitted_width)*parseFloat(total_kitchen_type_done_items)).toFixed(2);

						if(i==1){
							$order_list_left += '<div data-started-cooking="'+total_kitchen_type_started_cooking_items+'" data-done-cooking="'+total_kitchen_type_done_items+'" class="single_order fix" style="margin-top:0px" data-selected="unselected" id="order_'+response[key].sales_id+'">';	
						}else{
							$order_list_left += '<div data-started-cooking="'+total_kitchen_type_started_cooking_items+'" data-done-cooking="'+total_kitchen_type_done_items+'" class="single_order fix" data-selected="unselected" id="order_'+response[key].sales_id+'">';	
						}
						$order_list_left +='<div class="inside_single_order_container fix">';
					    // $order_list_left +='<div class="background_order_started" style="width:'+percentage_for_started_cooking+'%"></div>';
					    // $order_list_left +='<div class="background_order_done" style="width:'+percentage_for_done_cooking+'%"></div>';
					    $order_list_left +='<div class="single_order_content_holder_inside fix">';
						var order_name = '';
						if(response[key].order_type=='1'){
							order_name = 'A '+response[key].sale_no;
						}else if(response[key].order_type=='2'){
							order_name = 'B '+response[key].sale_no;
						}else if(response[key].order_type=='3'){
							order_name = 'C '+response[key].sale_no;
						}

						// var booked_time = new Date(Date.parse(response[key].date_time));
						// var now = new Date();
						
						// var  days = parseInt((now - booked_time) / (1000 * 60 * 60 * 24));
						// var  hours = parseInt(Math.abs(now - booked_time) / (1000 * 60 * 60) % 24);
						// var  minute = parseInt(Math.abs(now.getTime() - booked_time.getTime()) / (1000 * 60) % 60);
						// var  second = parseInt(Math.abs(now.getTime() - booked_time.getTime()) / (1000) % 60);
						// minute = minute.toString();
						// second = second.toString();
						// minute = (minute.length==1)?'0'+minute:minute;
						// second = (second.length==1)?'0'+second:second;

						minute = response[key].minute_difference;
						second = response[key].second_difference;

						var tables_booked = '';
					    if(response[key].tables_booked.length>0){
					        var w = 1;
					        for (var k in response[key].tables_booked) {
					        	var single_table = response[key].tables_booked[k];
					            if(w == response[key].tables_booked.length){
					                tables_booked += single_table.table_name;
					            }else{
					                tables_booked += single_table.table_name+', ';
					            }
					            w++;
					        }    
					    }else{
					        tables_booked = 'None';
					    }

						var table_name = (response[key].table_name!=null)?response[key].table_name:"";
						var waiter_name = (response[key].waiter_name!=null)?response[key].waiter_name:"";
						var customer_name = (response[key].customer_name!=null)?response[key].customer_name:"";
						$order_list_left += '<span id="open_orders_order_status_'+response[key].sales_id+'" style="display:none;">'+response[key].order_status+'</span><p style="font-size: 16px;font-weight: bold;text-align:center;">Order: <span class="running_order_order_number">'+order_name+'</span></p>';
						$order_list_left += '<p>Table: <span class="running_order_table_name">'+tables_booked+'</span></p>';
						$order_list_left += '<p>Waiter: <span class="running_order_waiter_name">'+waiter_name+'</span></p>';
						$order_list_left += '<p>Customer: <span class="running_order_customer_name">'+customer_name+'</span></p>';
						$order_list_left += '</div>';
					    $order_list_left += '<div class="order_condition">';
					    $order_list_left += '<p class="order_on_processing">Started Cooking: '+total_kitchen_type_started_cooking_items+'/'+total_kitchen_type_items+'</p>';
					    $order_list_left += '<p class="order_done">Done: '+total_kitchen_type_done_items+'/'+total_kitchen_type_items+'</p>';
					    $order_list_left += '</div>';
					    $order_list_left += '<div class="order_condition">';
					    $order_list_left += '<p style="font-size:16px;">Time Count: <span id="order_minute_count_'+response[key].sales_id+'">'+minute+'</span>:<span id="order_second_count_'+response[key].sales_id+'">'+second+'</span> M</p>';
					    $order_list_left += '</div>';
						$order_list_left += '</div>';
						$order_list_left += '</div>';
						i++;
					}
					$('#order_details_holder').html($order_list_left);
					$('.order_table_holder .order_holder').empty();
					clearFooterCartCalculation();
					$('.main_top').find('button').css('background-color','#F3F3F3');
					$('.main_top').find('button').attr('data-selected','unselected');
					$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
					$('#select_waiter').val('');
					$('#select_walk_in_customer').val('1');
					reset_time_interval();
					all_time_interval_operation();
				},
				error:function(){
					alert("error");
				}
			});			
		},
		error:function(){
			alert("error");
		}
	});	
}
function reset_last_10_sales_modal(){
	$('.last_ten_sales_holder .hold_sale_left .detail_holder').empty();
	$('.last_ten_sales_holder .hold_sale_right .top_middle .item_modifier_details .modifier_item_details_holder').empty();
	$('#last_10_waiter_id').html('');
	$('#last_10_waiter_name').html('');
	$('#last_10_customer_id').html('');
	$('#last_10_customer_name').html('');
	$('#last_10_table_id').html('');
	$('#last_10_table_name').html('');
	$('#last_10_order_type').html('');
	$('#last_10_order_type_id').html('');
	$('#last_10_order_invoice_no').html('');
	$("#total_items_in_cart_last_10").html('0');
	$("#sub_total_show_last_10").html('0.00');
	$("#sub_total_last_10").html('0.00');
	$("#total_item_discount_last_10").html('0.00');
	$("#discounted_sub_total_amount_last_10").html('0.00');
	$("#sub_total_discount_last_10").html('');
	$("#sub_total_discount_amount_last_10").html('0.00');
	$("#all_items_vat_last_10").html('0.00');	
	$("#all_items_discount_last_10").html('0.00');
	$("#delivery_charge_last_10").html('0.00');
	$("#total_payable_last_10").html('0.00');	

}
function reset_finalize_modal(){
	$('#finalize_total_payable').html('0.00');
	$('#given_amount_input').val('');
	$('#change_amount_input').val('');
	$('#finalize_order_modal').hide();
	$('#finalie_order_payment_method').val("");
	$('#finalize_update_type').html('');
	$('#pay_amount_invoice_input').val('');
	$('#due_amount_invoice_input').val('');
	$('#finalie_order_payment_method').css('border','1px solid #B5D6F6');
}
function refresh_orders_left(){
	if($('.holder .order_details > .single_order[data-selected=selected]').length==0 && $('#stop_refresh_for_search').html()=='yes'){
		set_new_orders_to_view_for_interval();
	}		
}
function new_notification_interval(){
	 
	$.ajax({
		url:base_url+"Sale/get_new_notifications_ajax",
		method:"POST",
		data:{
			csrf_test_name: $.cookie('csrf_cookie_name')
		},
		success:function(response) {
			response = JSON.parse(response);
			var notification_counter_update = response.length;
			var notification_counter_previous = $('#notification_counter').html();
			$('#notification_counter').html(notification_counter_update);
			if(notification_counter_update>notification_counter_previous){
				
				setTimeout(function(){ 
					$('#notification_button').css('background-color','#dc3545')
					$('#notification_button').css('color','#fff'); 
				}, 500);
				setTimeout(function(){ 
					$('#notification_button').css('background-color','#ccc');
					$('#notification_button').css('color','buttontext'); 
				}, 1000);
				setTimeout(function(){ 
					$('#notification_button').css('background-color','#dc3545')
					$('#notification_button').css('color','#fff'); 
				}, 1500);
				setTimeout(function(){ 
					$('#notification_button').css('background-color','#ccc');
					$('#notification_button').css('color','buttontext'); 
				}, 2000);
				setTimeout(function(){ 
					$('#notification_button').css('background-color','#dc3545')
					$('#notification_button').css('color','#fff'); 
				}, 2500);
				setTimeout(function(){ 
					$('#notification_button').css('background-color','#ccc');
					$('#notification_button').css('color','buttontext'); 
				}, 3000);
				setTimeout(function(){ 
					$('#notification_button').css('background-color','#dc3545')
					$('#notification_button').css('color','#fff'); 
				}, 3500);
			}

			// $order_list_left = '';
			// var i = 1;
			var notifications_list = '';
			for (var key in response) {
				var this_notification = response[key];
				notifications_list += '<div class="single_row_notification fix" id="single_notification_row_'+this_notification.id+'">';
					notifications_list += '<div class="fix single_notification_check_box">';
						notifications_list += '<input class="single_notification_checkbox" type="checkbox" id="single_notification_'+this_notification.id+'" value="'+this_notification.id+'">';
					notifications_list += '</div>';
					notifications_list += '<div class="fix single_notification">'+this_notification.notification+'</div>';
					notifications_list += '<div class="fix single_serve_button">';
						notifications_list += '<button class="single_serve_b" id="notification_serve_button_'+this_notification.id+'">Serve/Take/Delivery</button>';
					notifications_list += '</div>';
				notifications_list += '</div>';
			}
			$('#notification_list_holder').html(notifications_list);
		},
		error:function(){
			console.log("Notification refresh error");
		}
	});			
}

function reset_time_interval(){
	for (var i = 1; i < 99999; i++)
    window.clearInterval(i);
}
function order_time_interval(){
	setInterval(function(){ 
	$('#order_details_holder .single_order').each(function(i, obj) {
			var order_id = $(this).attr('id').substr(6);
			var minutes = $('#order_minute_count_'+order_id).html();
			var seconds = $('#order_second_count_'+order_id).html();
			upTimeSingleOrder($(this),minutes,seconds);
		});
	}, 1000);	
}

function all_time_interval_operation(){
	order_time_interval();	
	setInterval(function(){ 
		new_notification_interval();
		refresh_orders_left();
	}, 15000);
	
}
all_time_interval_operation();
function upTimeSingleOrder(object,minute,second) {
  order_id = object.attr('id').substr(6);
  if($('#ordered_minute_'+order_id).html()=='00' && $('#ordered_second_'+order_id).html()=='00'){
  	return false;
  }
  second++;
  if(second==60){
  	minute++;
  	second=0;
  }
  
  minute = minute.toString();
  second = second.toString();
  minute = (minute.length==1)?'0'+minute:minute;
  second = (second.length==1)?'0'+second:second;
  $('#order_minute_count_'+order_id).html(minute);
  $('#order_second_count_'+order_id).html(second);

  // upTime2.to=setTimeout(function(){ upTime2(object,second,minute,hour); },1000);
}
function set_calculator_position() {
	var calculator_button_top = $('#calculator_button').offset().top;
	var calculator_button_left = $('#calculator_button').offset().left;
	var calculator_button_height = $('#calculator_button').height();
	var calculator_button_width = $('#calculator_button').width();
	var calculator_width = $('#calculator_main').width();
	var left_for_calculator = calculator_button_left+calculator_button_width+calculator_button_width-calculator_width;
	var total_top_for_calculator = calculator_button_top + calculator_button_height+5;
	$('#calculator_main').css('top',total_top_for_calculator).css('left',left_for_calculator);
}
function arrange_info_on_the_cart_to_modify(response){
	sale_id = response.id;
	var draw_table_for_order='';
	
	for (var key in response.items) {

		//construct div
		var this_item = response.items[key];
		
		var selected_modifiers = '';
		var selected_modifiers_id = '';
		var selected_modifiers_price = '';
		var modifiers_price = 0;
		var total_modifier = this_item.modifiers.length;
		var i = 1;
		for(var mod_key in this_item.modifiers)
		{
			var this_modifier = this_item.modifiers[mod_key];
			//get selected modifiers
	    	if(i == total_modifier){
    			selected_modifiers += this_modifier.name;
    			selected_modifiers_id += this_modifier.modifier_id;
    			selected_modifiers_price += this_modifier.modifier_price;
	    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
	    	}else{
    			selected_modifiers += this_modifier.name+',';
    			selected_modifiers_id += this_modifier.modifier_id+',';
	    		selected_modifiers_price += this_modifier.modifier_price+',';
	    		modifiers_price = (parseFloat(modifiers_price)+parseFloat(this_modifier.modifier_price)).toFixed(2);
	    	}
		    i++;
		}
		var previous_id = (this_item.previous_id=='' || this_item.previous_id==null)?'':this_item.previous_id;
		var cooking_done_time = (this_item.cooking_done_time=='' || this_item.cooking_done_time==null)?'':this_item.cooking_done_time;
		var cooking_start_time = (this_item.cooking_start_time=='' || this_item.cooking_start_time==null)?'':this_item.cooking_start_time;
		var cooking_status = (this_item.cooking_status=='' || this_item.cooking_status==null)?'':this_item.cooking_status;
		var item_type = (this_item.item_type=='' || this_item.item_type==null)?'':this_item.item_type;
		draw_table_for_order += '<div class="single_order fix" id="order_for_item_'+this_item.food_menu_id+'">';
			draw_table_for_order += '<div class="first_portion fix">';
				draw_table_for_order += '<span class="item_previous_id" id="item_previous_id_table'+this_item.food_menu_id+'" style="display:none;">'+previous_id+'</span>';
				draw_table_for_order += '<span class="item_cooking_done_time" id="item_cooking_done_time_table'+this_item.food_menu_id+'" style="display:none;">'+cooking_done_time+'</span>';
				draw_table_for_order += '<span class="item_cooking_start_time" id="item_cooking_start_time_table'+this_item.food_menu_id+'" style="display:none;">'+cooking_start_time+'</span>';
				draw_table_for_order += '<span class="item_cooking_status" id="item_cooking_status_table'+this_item.food_menu_id+'" style="display:none;">'+cooking_status+'</span>';
				draw_table_for_order += '<span class="item_type" id="item_type_table'+this_item.food_menu_id+'" style="display:none;">'+item_type+'</span>';
				draw_table_for_order += '<span class="item_vat" id="item_vat_percentage_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_vat_percentage+'</span>';
				draw_table_for_order += '<span class="item_discount" id="item_discount_table'+this_item.food_menu_id+'" style="display:none;">'+this_item.discount_amount+'</span>';
				draw_table_for_order += '<span class="item_price_without_discount" id="item_price_without_discount_'+this_item.food_menu_id+'" style="display:none;">'+this_item.menu_price_without_discount+'</span>';
				draw_table_for_order += '<div class="single_order_column first_column fix"><i style="cursor:pointer;" class="fas fa-pencil-alt edit_item" id="edit_item_'+this_item.food_menu_id+'"></i> <span id="item_name_table_'+this_item.food_menu_id+'">'+this_item.menu_name+'</span></div>';
				draw_table_for_order += '<div class="single_order_column second_column fix">'+currency+' <span id="item_price_table_'+this_item.food_menu_id+'">'+this_item.menu_unit_price+'</span></div>';
				draw_table_for_order += '<div class="single_order_column third_column fix"><i style="cursor:pointer;" class="fas fa-minus-circle decrease_item_table" id="decrease_item_table_'+this_item.food_menu_id+'"></i> <span id="item_quantity_table_'+this_item.food_menu_id+'">'+this_item.qty+'</span> <i style="cursor:pointer;" class="fas fa-plus-circle increase_item_table" id="increase_item_table_'+this_item.food_menu_id+'"></i></div>';
				draw_table_for_order += '<div class="single_order_column forth_column fix"><input type="" name="" placeholder="Amt or %" class="special_textbox" id="percentage_table_'+this_item.food_menu_id+'" value="'+this_item.menu_discount_value+'" disabled></div>';
				draw_table_for_order += '<div class="single_order_column fifth_column fix">'+currency+' <span id="item_total_price_table_'+this_item.food_menu_id+'">'+this_item.menu_price_with_discount+'</span></div>';
			draw_table_for_order += '</div>';
			if(selected_modifiers!=""){
				draw_table_for_order += '<div class="second_portion fix">';
					draw_table_for_order += '<span id="item_modifiers_id_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_id+'</span>';
					draw_table_for_order += '<span id="item_modifiers_price_table_'+this_item.food_menu_id+'" style="display:none;">'+selected_modifiers_price+'</span>';
					draw_table_for_order += '<div class="single_order_column first_column fix"><span id="item_modifiers_table_'+this_item.food_menu_id+'">'+selected_modifiers+'</span></div>';
					draw_table_for_order += '<div class="single_order_column fifth_column fix">'+currency+' <span id="item_modifiers_price_table_'+this_item.food_menu_id+'">'+modifiers_price+'</span></div>';
				draw_table_for_order += '</div>';
			}
			if(this_item.menu_note!=""){
				draw_table_for_order += '<div class="third_portion fix">';
					draw_table_for_order += '<div class="single_order_column first_column fix">Note: <span id="item_note_table_'+this_item.food_menu_id+'">'+this_item.menu_note+'</span></div>';
				draw_table_for_order += '</div>';	
			}
			
		draw_table_for_order += '</div>';


	}
	//add to top
	$(".order_holder").prepend(draw_table_for_order);
	$("#total_items_in_cart").html(response.total_items);
	$("#sub_total_show").html(response.sub_total);
	$("#sub_total").html(response.sub_total);
	$("#total_item_discount").html(response.total_item_discount_amount);
	$("#discounted_sub_total_amount").html(response.sub_total_discount_amount);
	$("#sub_total_discount").val(response.sub_total_discount_value);
	$("#sub_total_discount_amount").html(response.sub_total_with_discount);
	$("#all_items_vat").html(response.vat);	
	$("#all_items_discount").html(response.total_discount_amount);
	$("#delivery_charge").val(response.delivery_charge);
	$("#total_payable").html(response.total_payable);
	$(".order_holder").prepend('<span data-sale-no="'+response.sale_no+'" id="modification_'+sale_id+'" class="modification" style="display:none;">'+sale_id+'</span>');
	
	if(response.customer_id=="" || response.customer_id==0 || response.customer_id==null){
		$("#walk_in_customer").val(1).trigger("change");	
	}else{
		$("#walk_in_customer").val(response.customer_id).trigger("change");
	}

	if(response.waiter_id=="" || response.waiter_id==0 || response.waiter_id==null){
		$("#select_waiter").val('').trigger("change");	
	}else{
		$("#select_waiter").val(response.waiter_id).trigger("change");
	}
	if(response.order_type=='1'){
		$('.main_top').find('button').css('background-color','#F3F3F3');
		$('.main_top').find('button').attr('data-selected','unselected');

		$('#dine_in_button').css('background-color','#B5D6F6'); 
		$('#dine_in_button').attr('data-selected','selected');

		$('#table_button').attr('disabled',false);

	}else if(response.order_type=='2'){
		$('.main_top').find('button').css('background-color','#F3F3F3');
		$('.main_top').find('button').attr('data-selected','unselected');

		$('#take_away_button').css('background-color','#B5D6F6'); 
		$('#take_away_button').attr('data-selected','selected');

		$('#table_button').attr('disabled',false);
		
	}else if(response.order_type=='3'){
		$('.main_top').find('button').css('background-color','#F3F3F3');
		$('.main_top').find('button').attr('data-selected','unselected');

		$('#delivery_button').css('background-color','#B5D6F6'); 
		$('#delivery_button').attr('data-selected','selected');

		$('#table_button').attr('disabled',true);
		$('.single_table_div[data-table-checked=checked]').attr('data-table-checked','unchecked');
		$('.single_table_div[data-table-checked=checked]').css('background-color','#ffffff');
	}else{
		$('.main_top').find('button').css('background-color','#F3F3F3');
		$('.main_top').find('button').attr('data-selected','unselected');
	}	

	//do calculation on table
	do_addition_of_item_and_modifiers_price();
} 
function reset_table_modal(){
	$('.bottom_person').val('1');
	$('.new_book_to_table').remove();
	$('.single_table_order_details_holder .bottom').css('display','block');
}